/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.data.instance.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.text.WordUtils;
import org.bonitasoft.engine.cache.CacheService;
import org.bonitasoft.engine.cache.SCacheException;
import org.bonitasoft.engine.commons.ClassReflector;
import org.bonitasoft.engine.commons.exceptions.SReflectException;
import org.bonitasoft.engine.core.data.instance.TransientDataService;
import org.bonitasoft.engine.data.instance.exception.SCreateDataInstanceException;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceNotFoundException;
import org.bonitasoft.engine.data.instance.exception.SUpdateDataInstanceException;
import org.bonitasoft.engine.data.instance.model.SDataInstance;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;

public class TransientDataServiceImpl
implements TransientDataService {
    private static final String TRANSIENT_DATA_CACHE_NAME = "transient_data";
    private final CacheService cacheService;

    public TransientDataServiceImpl(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    @Override
    public List<SDataInstance> getDataInstances(List<String> dataNames, long containerId, String containerType) throws SDataInstanceException {
        ArrayList<SDataInstance> data = new ArrayList<SDataInstance>(dataNames.size());
        for (String dataName : dataNames) {
            data.add(this.getDataInstance(dataName, containerId, containerType));
        }
        return data;
    }

    private String getKey(String dataInstanceName, long containerId, String containerType) {
        return dataInstanceName + ":" + containerId + ":" + containerType;
    }

    private String getKey(SDataInstance dataInstance) {
        return this.getKey(dataInstance.getName(), dataInstance.getContainerId(), dataInstance.getContainerType());
    }

    @Override
    public void createDataInstance(SDataInstance dataInstance) throws SDataInstanceException {
        try {
            String dataInstanceKey = this.getKey(dataInstance);
            if (this.checkDataAlreadyExists(dataInstanceKey)) {
                this.handleDataAlreadyExists(dataInstance);
            }
            this.setId(dataInstance);
            this.cacheService.store(TRANSIENT_DATA_CACHE_NAME, (Serializable)((Object)dataInstanceKey), dataInstance);
        }
        catch (Exception e) {
            throw new SDataInstanceException("Impossible to store transient data", e);
        }
    }

    private void setId(SDataInstance dataInstance) throws SecurityException, IllegalArgumentException, SReflectException {
        long id = Math.abs(UUID.randomUUID().getMostSignificantBits());
        ClassReflector.invokeSetter(dataInstance, "setId", Long.TYPE, id);
    }

    private void handleDataAlreadyExists(SDataInstance dataInstance) throws SCreateDataInstanceException {
        StringBuilder stb = new StringBuilder("Data already exists: name = ");
        stb.append(dataInstance.getName());
        stb.append(", container type = ");
        stb.append(dataInstance.getContainerType());
        stb.append(", containerId = ");
        stb.append(dataInstance.getContainerId());
        throw new SCreateDataInstanceException(stb.toString());
    }

    private boolean checkDataAlreadyExists(String dataInstanceKey) throws SCacheException {
        List<?> keys = this.getCacheKeys(TRANSIENT_DATA_CACHE_NAME);
        return keys.contains(dataInstanceKey);
    }

    @Override
    public void updateDataInstance(SDataInstance dataInstance, EntityUpdateDescriptor descriptor) throws SDataInstanceException {
        try {
            String key = this.getKey(dataInstance);
            for (Map.Entry<String, Object> field : descriptor.getFields().entrySet()) {
                try {
                    String setterName = "set" + WordUtils.capitalize((String)field.getKey());
                    ClassReflector.invokeMethodByName(dataInstance, setterName, field.getValue());
                }
                catch (Exception e) {
                    throw new SUpdateDataInstanceException("Problem while updating entity: " + dataInstance + " with id: " + dataInstance.getId() + " in TransientDataInstanceDataSource.", e);
                }
            }
            this.cacheService.store(TRANSIENT_DATA_CACHE_NAME, (Serializable)((Object)key), dataInstance);
        }
        catch (SCacheException e) {
            throw new SDataInstanceException("Impossible to update transient data", e);
        }
    }

    @Override
    public void deleteDataInstance(SDataInstance dataInstance) throws SDataInstanceException {
        try {
            String key = this.getKey(dataInstance);
            this.cacheService.remove(TRANSIENT_DATA_CACHE_NAME, key);
        }
        catch (SCacheException e) {
            throw new SDataInstanceException("Impossible to delete transient data", e);
        }
    }

    @Override
    public SDataInstance getDataInstance(long dataInstanceId) throws SDataInstanceException {
        try {
            List<?> cacheKeys = this.getCacheKeys(TRANSIENT_DATA_CACHE_NAME);
            for (Object key : cacheKeys) {
                SDataInstance dataInstance = (SDataInstance)this.cacheService.get(TRANSIENT_DATA_CACHE_NAME, key);
                if (dataInstance == null || dataInstance.getId() != dataInstanceId) continue;
                return dataInstance;
            }
        }
        catch (SCacheException e) {
            throw new SDataInstanceException("Impossible to get transient data: ", e);
        }
        throw new SDataInstanceNotFoundException("No data found. Id: " + dataInstanceId);
    }

    @Override
    public SDataInstance getDataInstance(String dataName, long containerId, String containerType) throws SDataInstanceException {
        try {
            List<?> cacheKeys = this.getCacheKeys(TRANSIENT_DATA_CACHE_NAME);
            String key = this.getKey(dataName, containerId, containerType);
            if (!cacheKeys.contains(key)) {
                this.handleDataInstanceNotFound(dataName, containerId, containerType);
            }
            return (SDataInstance)this.cacheService.get(TRANSIENT_DATA_CACHE_NAME, key);
        }
        catch (SCacheException e) {
            throw new SDataInstanceException("Impossible to get transient data: ", e);
        }
    }

    private List<?> getCacheKeys(String cacheName) throws SCacheException {
        List<Object> cacheKeys = Collections.emptyList();
        if (this.cacheService.getCachesNames().contains(cacheName)) {
            cacheKeys = this.cacheService.getKeys(cacheName);
        }
        return cacheKeys;
    }

    private void handleDataInstanceNotFound(String dataName, long containerId, String containerType) throws SDataInstanceNotFoundException {
        StringBuilder stb = new StringBuilder("No data found. Name: ");
        stb.append(dataName);
        stb.append(" contanierId: ");
        stb.append(containerId);
        stb.append(" container type: ");
        stb.append(containerType);
        throw new SDataInstanceNotFoundException(stb.toString());
    }

    @Override
    public List<SDataInstance> getDataInstances(long containerId, String containerType, int fromIndex, int numberOfResults) throws SDataInstanceException {
        String matchingKey = containerId + ":" + containerType;
        ArrayList<SDataInstance> dataInstances = new ArrayList<SDataInstance>();
        try {
            List<?> cacheKeys = this.getCacheKeys(TRANSIENT_DATA_CACHE_NAME);
            for (int i = fromIndex; i < cacheKeys.size() && i < numberOfResults; ++i) {
                SDataInstance dataInstance;
                Object key = cacheKeys.get(i);
                if (!((String)key).contains(matchingKey) || (dataInstance = this.getDataInstance(((String)key).substring(0, ((String)key).indexOf(":")), containerId, containerType)) == null) continue;
                dataInstances.add(dataInstance);
            }
            if (!dataInstances.isEmpty()) {
                return dataInstances;
            }
            return Collections.emptyList();
        }
        catch (SCacheException e) {
            throw new SDataInstanceException("Impossible to get transient data: ", e);
        }
    }

    @Override
    public List<SDataInstance> getDataInstances(List<Long> dataInstanceIds) {
        ArrayList<SDataInstance> results = new ArrayList<SDataInstance>(dataInstanceIds.size());
        for (Long dataInstanceId : dataInstanceIds) {
            try {
                results.add(this.getDataInstance(dataInstanceId));
            }
            catch (SDataInstanceException e) {}
        }
        return results;
    }
}

