/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.bonitasoft.engine.expression.ContainerState;
import org.bonitasoft.engine.expression.ExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.ExpressionKind;
import org.bonitasoft.engine.expression.model.SExpression;

public class ConstantExpressionExecutorStrategy
implements ExpressionExecutorStrategy {
    private static final String REGEX_PARSE_DATE = "(\\d{4})(-([01]\\d)((-([0-3]\\d)(T(\\d\\d)\\:(\\d\\d)(((\\:(\\d\\d))?(\\.(\\d\\d))?(([\\+-])(\\d\\d)\\:(\\d\\d))?)?)?)?)?)?)?";

    @Override
    public void validate(SExpression expression) throws SInvalidExpressionException {
        if ("".equals(expression.getContent().trim())) {
            throw new SInvalidExpressionException("The expresssion content cannot be empty. Expression : " + expression, expression.getName());
        }
    }

    @Override
    public ExpressionKind getExpressionKind() {
        return KIND_CONSTANT;
    }

    @Override
    public Object evaluate(SExpression expression, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionEvaluationException {
        Object result;
        block9: {
            String expressionContent = expression.getContent();
            String returnType = expression.getReturnType();
            try {
                if (Boolean.class.getName().equals(returnType)) {
                    result = Boolean.parseBoolean(expressionContent);
                    break block9;
                }
                if (Long.class.getName().equals(returnType)) {
                    result = Long.parseLong(expressionContent);
                    break block9;
                }
                if (Double.class.getName().equals(returnType)) {
                    result = Double.parseDouble(expressionContent);
                    break block9;
                }
                if (Float.class.getName().equals(returnType)) {
                    result = Float.valueOf(Float.parseFloat(expressionContent));
                    break block9;
                }
                if (Integer.class.getName().equals(returnType)) {
                    result = Integer.parseInt(expressionContent);
                    break block9;
                }
                if (String.class.getName().equals(returnType)) {
                    result = expressionContent;
                    break block9;
                }
                if (Date.class.getName().equals(returnType)) {
                    result = this.parseDate(expressionContent);
                    break block9;
                }
                throw new SExpressionEvaluationException("Unknown return type: " + returnType + " for expression " + expression.getName() + " : " + expressionContent, expression.getName());
            }
            catch (NumberFormatException e) {
                throw new SExpressionEvaluationException("The content of the expression \"" + expression.getName() + "\" is not a number :" + expressionContent, e, expression.getName());
            }
        }
        return result;
    }

    @Override
    public List<Object> evaluate(List<SExpression> expressions, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionEvaluationException {
        ArrayList<Object> list = new ArrayList<Object>(expressions.size());
        for (SExpression expression : expressions) {
            list.add(this.evaluate(expression, context, resolvedExpressions, containerState));
        }
        return list;
    }

    @Override
    public boolean mustPutEvaluatedExpressionInContext() {
        return false;
    }

    private Date parseDate(String dateToParse) {
        if (dateToParse.matches(REGEX_PARSE_DATE)) {
            String fractional;
            String secondes;
            String minutes;
            String hour;
            String day;
            String month;
            Calendar calendar = Calendar.getInstance();
            String year = dateToParse.replaceFirst(REGEX_PARSE_DATE, "$1");
            if (year != null && !year.isEmpty() && Integer.valueOf(year) > 1900) {
                calendar.set(1, Integer.valueOf(year));
            }
            if ((month = dateToParse.replaceFirst(REGEX_PARSE_DATE, "$3")) != null && !month.isEmpty() && Integer.valueOf(month) < 13) {
                calendar.set(2, Integer.valueOf(month) - 1);
            }
            if ((day = dateToParse.replaceFirst(REGEX_PARSE_DATE, "$6")) != null && !day.isEmpty() && Integer.valueOf(day) < 32) {
                calendar.set(5, Integer.valueOf(day));
            }
            if ((hour = dateToParse.replaceFirst(REGEX_PARSE_DATE, "$8")) != null && !hour.isEmpty() && Integer.valueOf(hour) < 24) {
                calendar.set(11, Integer.valueOf(hour));
            }
            if ((minutes = dateToParse.replaceFirst(REGEX_PARSE_DATE, "$9")) != null && !minutes.isEmpty() && Integer.valueOf(minutes) < 60) {
                calendar.set(12, Integer.valueOf(minutes));
            }
            if ((secondes = dateToParse.replaceFirst(REGEX_PARSE_DATE, "$13")) != null && !secondes.isEmpty() && Integer.valueOf(secondes) < 60) {
                calendar.set(13, Integer.valueOf(secondes));
            }
            if ((fractional = dateToParse.replaceFirst(REGEX_PARSE_DATE, "$15")) != null && !fractional.isEmpty() && Integer.valueOf(fractional) < 60) {
                calendar.set(14, Integer.valueOf(fractional));
            }
            String tzSign = dateToParse.replaceFirst(REGEX_PARSE_DATE, "$17");
            String tzHour = dateToParse.replaceFirst(REGEX_PARSE_DATE, "$18");
            String tzMinutes = dateToParse.replaceFirst(REGEX_PARSE_DATE, "$19");
            TimeZone tz = TimeZone.getTimeZone("GMT" + tzSign + tzHour + tzMinutes);
            if (!(tzSign.isEmpty() || tzHour.isEmpty() || tzMinutes.isEmpty() || tz == null)) {
                calendar.setTimeZone(tz);
            }
            return calendar.getTime();
        }
        return null;
    }
}

