/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.profile;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.api.ImportError;
import org.bonitasoft.engine.api.ImportStatus;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.Pair;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.exception.ExecutionException;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SGroupNotFoundException;
import org.bonitasoft.engine.identity.SRoleNotFoundException;
import org.bonitasoft.engine.identity.SUserNotFoundException;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.identity.model.SRole;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.profile.DeleteExistingImportStrategy;
import org.bonitasoft.engine.profile.FailOnDuplicateImportStrategy;
import org.bonitasoft.engine.profile.IgnoreDuplicateImportStrategy;
import org.bonitasoft.engine.profile.ImportPolicy;
import org.bonitasoft.engine.profile.ProfileImportStategy;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.profile.ReplaceDuplicateImportStrategy;
import org.bonitasoft.engine.profile.builder.SProfileBuilderFactory;
import org.bonitasoft.engine.profile.builder.SProfileEntryBuilderFactory;
import org.bonitasoft.engine.profile.exception.profile.SProfileCreationException;
import org.bonitasoft.engine.profile.exception.profile.SProfileNotFoundException;
import org.bonitasoft.engine.profile.exception.profile.SProfileUpdateException;
import org.bonitasoft.engine.profile.exception.profileentry.SProfileEntryCreationException;
import org.bonitasoft.engine.profile.exception.profileentry.SProfileEntryDeletionException;
import org.bonitasoft.engine.profile.exception.profilemember.SProfileMemberCreationException;
import org.bonitasoft.engine.profile.exception.profilemember.SProfileMemberDeletionException;
import org.bonitasoft.engine.profile.impl.ExportedParentProfileEntry;
import org.bonitasoft.engine.profile.impl.ExportedProfile;
import org.bonitasoft.engine.profile.impl.ExportedProfileEntry;
import org.bonitasoft.engine.profile.impl.ExportedProfileMapping;
import org.bonitasoft.engine.profile.model.SProfile;
import org.bonitasoft.engine.profile.model.SProfileEntry;
import org.bonitasoft.engine.xml.Parser;
import org.bonitasoft.engine.xml.SValidationException;
import org.bonitasoft.engine.xml.SXMLParseException;

public class ProfilesImporter {
    private final ProfileService profileService;
    private final IdentityService identityService;
    private final List<ExportedProfile> exportedProfiles;
    private final ProfileImportStategy importStrategy;

    public ProfilesImporter(ProfileService profileService, IdentityService identityService, List<ExportedProfile> exportedProfiles, ImportPolicy policy) {
        this(profileService, identityService, exportedProfiles, ProfilesImporter.getStrategy(profileService, policy));
    }

    private static ProfileImportStategy getStrategy(ProfileService profileService, ImportPolicy policy) {
        switch (policy) {
            case DELETE_EXISTING: {
                return new DeleteExistingImportStrategy(profileService);
            }
            case FAIL_ON_DUPLICATES: {
                return new FailOnDuplicateImportStrategy(profileService);
            }
            case IGNORE_DUPLICATES: {
                return new IgnoreDuplicateImportStrategy(profileService);
            }
            case REPLACE_DUPLICATES: {
                return new ReplaceDuplicateImportStrategy(profileService);
            }
        }
        return null;
    }

    ProfilesImporter(ProfileService profileService, IdentityService identityService, List<ExportedProfile> exportedProfiles, ProfileImportStategy importStrategy) {
        this.profileService = profileService;
        this.identityService = identityService;
        this.exportedProfiles = exportedProfiles;
        this.importStrategy = importStrategy;
    }

    public List<ImportStatus> importProfiles(long importerId) throws ExecutionException {
        this.importStrategy.beforeImport();
        try {
            ArrayList<ImportStatus> importStatus = new ArrayList<ImportStatus>(this.exportedProfiles.size());
            for (ExportedProfile exportedProfile : this.exportedProfiles) {
                if (exportedProfile.getName() == null || exportedProfile.getName().isEmpty()) continue;
                ImportStatus currentStatus = new ImportStatus(exportedProfile.getName());
                importStatus.add(currentStatus);
                SProfile existingProfile = null;
                try {
                    existingProfile = this.profileService.getProfileByName(exportedProfile.getName());
                    currentStatus.setStatus(ImportStatus.Status.REPLACED);
                }
                catch (SProfileNotFoundException e1) {
                    // empty catch block
                }
                SProfile newProfile = this.importTheProfile(importerId, exportedProfile, existingProfile);
                if (newProfile == null) {
                    currentStatus.setStatus(ImportStatus.Status.SKIPPED);
                    continue;
                }
                long profileId = newProfile.getId();
                if (existingProfile == null || !exportedProfile.isDefault() && !existingProfile.isDefault()) {
                    currentStatus.getErrors().addAll(this.importProfileEntries(this.profileService, exportedProfile.getParentProfileEntries(), profileId));
                }
                currentStatus.getErrors().addAll(this.importProfileMapping(this.profileService, this.identityService, profileId, exportedProfile.getProfileMapping()));
            }
            return importStatus;
        }
        catch (SBonitaException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    protected List<ImportError> importProfileEntries(ProfileService profileService, List<ExportedParentProfileEntry> parentProfileEntries, long profileId) throws SProfileEntryCreationException {
        ArrayList<ImportError> errors = new ArrayList<ImportError>();
        for (ExportedParentProfileEntry parentProfileEntry : parentProfileEntries) {
            if (parentProfileEntry.hasErrors()) {
                errors.addAll(parentProfileEntry.getErrors());
                continue;
            }
            SProfileEntry parentEntry = profileService.createProfileEntry(this.createProfileEntry(parentProfileEntry, profileId, 0L));
            long parentProfileEntryId = parentEntry.getId();
            List<ExportedProfileEntry> childrenProfileEntry = parentProfileEntry.getChildProfileEntries();
            if (childrenProfileEntry == null || childrenProfileEntry.size() <= 0) continue;
            for (ExportedProfileEntry childProfileEntry : childrenProfileEntry) {
                if (childProfileEntry.hasError()) {
                    errors.add(childProfileEntry.getError());
                    continue;
                }
                profileService.createProfileEntry(this.createProfileEntry(childProfileEntry, profileId, parentProfileEntryId));
            }
        }
        return errors;
    }

    List<ImportError> importProfileMapping(ProfileService profileService, IdentityService identityService, long profileId, ExportedProfileMapping exportedProfileMapping) throws SProfileMemberCreationException {
        SGroup group;
        ArrayList<ImportError> errors = new ArrayList<ImportError>();
        for (String string : exportedProfileMapping.getUsers()) {
            SUser user = null;
            try {
                user = identityService.getUserByUserName(string);
            }
            catch (SUserNotFoundException e) {
                errors.add(new ImportError(string, ImportError.Type.USER));
                continue;
            }
            profileService.addUserToProfile(profileId, user.getId(), user.getFirstName(), user.getLastName(), user.getUserName());
        }
        for (String string : exportedProfileMapping.getGroups()) {
            group = null;
            try {
                group = identityService.getGroupByPath(string);
            }
            catch (SGroupNotFoundException e) {
                errors.add(new ImportError(string, ImportError.Type.GROUP));
                continue;
            }
            profileService.addGroupToProfile(profileId, group.getId(), group.getName(), group.getParentPath());
        }
        for (String string : exportedProfileMapping.getRoles()) {
            SRole role = null;
            try {
                role = identityService.getRoleByName(string);
            }
            catch (SRoleNotFoundException e) {
                errors.add(new ImportError(string, ImportError.Type.ROLE));
                continue;
            }
            profileService.addRoleToProfile(profileId, role.getId(), role.getName());
        }
        for (Pair pair : exportedProfileMapping.getMemberships()) {
            group = null;
            try {
                group = identityService.getGroupByPath((String)pair.getKey());
            }
            catch (SGroupNotFoundException e) {
                errors.add(new ImportError((String)pair.getKey(), ImportError.Type.GROUP));
            }
            SRole role = null;
            try {
                role = identityService.getRoleByName((String)pair.getValue());
            }
            catch (SRoleNotFoundException e) {
                errors.add(new ImportError((String)pair.getValue(), ImportError.Type.ROLE));
            }
            if (group == null || role == null) continue;
            profileService.addRoleAndGroupToProfile(profileId, role.getId(), group.getId(), role.getName(), group.getName(), group.getParentPath());
        }
        return errors;
    }

    protected SProfile importTheProfile(long importerId, ExportedProfile exportedProfile, SProfile existingProfile) throws ExecutionException, SProfileEntryDeletionException, SProfileMemberDeletionException, SProfileUpdateException, SProfileCreationException {
        SProfile newProfile = existingProfile != null ? this.importStrategy.whenProfileExists(importerId, exportedProfile, existingProfile) : (this.importStrategy.canCreateProfileIfNotExists(exportedProfile) ? this.profileService.createProfile(this.createSProfile(exportedProfile, importerId)) : null);
        return newProfile;
    }

    SProfile createSProfile(ExportedProfile exportedProfile, long importerId) {
        boolean isDefault = exportedProfile.isDefault();
        long creationDate = System.currentTimeMillis();
        return BuilderFactory.get(SProfileBuilderFactory.class).createNewInstance(exportedProfile.getName(), isDefault, creationDate, importerId, creationDate, importerId).setDescription(exportedProfile.getDescription()).done();
    }

    protected SProfileEntry createProfileEntry(ExportedParentProfileEntry parentEntry, long profileId, long parentId) {
        return BuilderFactory.get(SProfileEntryBuilderFactory.class).createNewInstance(parentEntry.getName(), profileId).setDescription(parentEntry.getDescription()).setIndex(parentEntry.getIndex()).setPage(parentEntry.getPage()).setParentId(parentId).setType(parentEntry.getType()).setCustom(new Boolean(parentEntry.isCustom())).done();
    }

    protected SProfileEntry createProfileEntry(ExportedProfileEntry childEntry, long profileId, long parentId) {
        return BuilderFactory.get(SProfileEntryBuilderFactory.class).createNewInstance(childEntry.getName(), profileId).setDescription(childEntry.getDescription()).setIndex(childEntry.getIndex()).setPage(childEntry.getPage()).setParentId(parentId).setType(childEntry.getType()).setCustom(new Boolean(childEntry.isCustom())).done();
    }

    public static List<String> toWarnings(List<ImportStatus> importProfiles) {
        ArrayList<String> warns = new ArrayList<String>();
        for (ImportStatus importStatus : importProfiles) {
            for (ImportError error : importStatus.getErrors()) {
                warns.add("Unable to find the " + error.getType().name().toLowerCase() + " " + error.getName() + " on " + importStatus.getName());
            }
        }
        return warns;
    }

    public static List<ExportedProfile> getProfilesFromXML(String xmlContent, Parser parser) throws ExecutionException {
        StringReader reader = new StringReader(xmlContent);
        try {
            parser.validate(reader);
            reader.close();
            reader = new StringReader(xmlContent);
            List list = (List)parser.getObjectFromXML(reader);
            return list;
        }
        catch (IOException ioe) {
            throw new ExecutionException((Throwable)ioe);
        }
        catch (SValidationException e) {
            throw new ExecutionException((Throwable)e);
        }
        catch (SXMLParseException e) {
            throw new ExecutionException((Throwable)e);
        }
        finally {
            reader.close();
        }
    }
}

