/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.operation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.core.operation.OperationExecutorStrategy;
import org.bonitasoft.engine.core.operation.exception.SOperationExecutionException;
import org.bonitasoft.engine.core.operation.model.SOperation;

public class OperationExecutorStrategyProvider {
    private final Map<String, OperationExecutorStrategy> operationStrategies;

    public OperationExecutorStrategyProvider(List<OperationExecutorStrategy> operationExecutors) {
        this.operationStrategies = new HashMap<String, OperationExecutorStrategy>(operationExecutors.size());
        for (OperationExecutorStrategy operationExecutorStrategy : operationExecutors) {
            this.operationStrategies.put(operationExecutorStrategy.getOperationType(), operationExecutorStrategy);
        }
    }

    public OperationExecutorStrategy getOperationExecutorStrategy(SOperation operation) throws SOperationExecutionException {
        String operatorTypeName = operation.getType().name();
        OperationExecutorStrategy operationExecutorStrategy = this.operationStrategies.get(operatorTypeName);
        if (operationExecutorStrategy == null) {
            throw new SOperationExecutionException("Unable to find an executor for operation type " + operatorTypeName);
        }
        return operationExecutorStrategy;
    }
}

