/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.document.mapping.recorder;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.engine.core.process.document.mapping.model.SDocumentMapping;
import org.bonitasoft.engine.core.process.document.mapping.model.archive.SADocumentMapping;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;

public class SelectDescriptorBuilder {
    public static <T extends PersistentObject> SelectByIdDescriptor<T> getElementById(Class<T> clazz, String elementName, long id) {
        return new SelectByIdDescriptor<T>("get" + elementName + "ById", clazz, id);
    }

    public static SelectListDescriptor<SDocumentMapping> getDocumentMappingsforProcessInstance(long processInstanceId, int fromIndex, int maxResults, String sortFieldOrder, OrderByType orderBy) {
        QueryOptions queryOptions = null;
        String queryName = "getDocumentMappingsforProcessInstance";
        if (sortFieldOrder == null) {
            queryOptions = new QueryOptions(fromIndex, maxResults);
            queryName = "getDocumentMappingsforProcessInstanceOrderedById";
        } else {
            queryOptions = new QueryOptions(fromIndex, maxResults, SDocumentMapping.class, sortFieldOrder, orderBy);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>(1);
        parameters.put("processInstanceId", processInstanceId);
        return new SelectListDescriptor<SDocumentMapping>(queryName, parameters, SDocumentMapping.class, queryOptions);
    }

    public static SelectOneDescriptor<Long> getNumberOfElement(String elementName, Class<? extends PersistentObject> clazz) {
        Map<String, Object> emptyMap = Collections.emptyMap();
        return new SelectOneDescriptor<Long>("getNumberOf" + elementName, emptyMap, clazz, Long.class);
    }

    public static SelectListDescriptor<SDocumentMapping> getDocumentMappings(int fromIndex, int maxResults, String sortFieldOrder, OrderByType orderBy) {
        Map<String, Object> emptyMap = Collections.emptyMap();
        QueryOptions queryOptions = null;
        queryOptions = sortFieldOrder == null ? new QueryOptions(fromIndex, maxResults) : new QueryOptions(fromIndex, maxResults, SDocumentMapping.class, sortFieldOrder, orderBy);
        return new SelectListDescriptor<SDocumentMapping>("getDocumentMappings", emptyMap, SDocumentMapping.class, queryOptions);
    }

    public static SelectOneDescriptor<SDocumentMapping> getDocumentByName(long processInstanceId, String documentName) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("documentName", documentName);
        return new SelectOneDescriptor<SDocumentMapping>("getDocumentMappingsforProcessInstanceAndName", parameters, SDocumentMapping.class);
    }

    public static SelectOneDescriptor<Long> getNumberOfDocumentMappingsforProcessInstance(long processInstanceId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(1);
        parameters.put("processInstanceId", processInstanceId);
        return new SelectOneDescriptor<Long>("getNumberOfDocumentMappingsforProcessInstance", parameters, SDocumentMapping.class);
    }

    public static SelectListDescriptor<SADocumentMapping> getArchivedDocumentByName(long processInstanceId, String documentName, long time) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("documentName", documentName);
        parameters.put("time", time);
        return new SelectListDescriptor<SADocumentMapping>("getSADocumentMappingsforProcessInstanceAndName", parameters, SADocumentMapping.class, new QueryOptions(0, 1));
    }

    public static SelectByIdDescriptor<SADocumentMapping> getArchivedDocumentById(long documentId) {
        return new SelectByIdDescriptor<SADocumentMapping>("getArchivedDocumentById", SADocumentMapping.class, documentId);
    }

    public static SelectOneDescriptor<SADocumentMapping> getArchivedVersionOdDocument(long documentId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(1);
        parameters.put("sourceObjectId", documentId);
        return new SelectOneDescriptor<SADocumentMapping>("getArchivedVersionOfDocument", parameters, SADocumentMapping.class);
    }
}

