/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution;

import java.io.IOException;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.exception.BonitaHomeConfigurationException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.execution.AbstractSetInFailedThread;
import org.bonitasoft.engine.execution.FlowNodeExecutor;
import org.bonitasoft.engine.execution.state.FlowNodeStateManager;
import org.bonitasoft.engine.sessionaccessor.STenantIdNotSetException;

public class SetFlowNodeInFailedThread
extends AbstractSetInFailedThread {
    private final long flowNodeInstanceId;
    private final long processDefinitionId;
    private final FlowNodeExecutor flowNodeExecutor;
    private long parentFlowNodeInstanceId;
    private String flowNodeInstanceName;

    public SetFlowNodeInFailedThread(long flowNodeInstanceId, long processDefinitionId, FlowNodeExecutor flowNodeExecutor) throws STenantIdNotSetException, BonitaHomeNotSetException, BonitaHomeConfigurationException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        this.flowNodeInstanceId = flowNodeInstanceId;
        this.processDefinitionId = processDefinitionId;
        this.flowNodeExecutor = flowNodeExecutor;
    }

    @Override
    protected void setInFail() throws SBonitaException {
        ActivityInstanceService activityInstanceService = this.getTenantServiceAccessor().getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = this.getTenantServiceAccessor().getFlowNodeStateManager();
        SFlowNodeInstance flowNodeInstance = activityInstanceService.getFlowNodeInstance(this.flowNodeInstanceId);
        this.parentFlowNodeInstanceId = flowNodeInstance.getParentProcessInstanceId();
        this.flowNodeInstanceName = flowNodeInstance.getName();
        this.flowNodeExecutor.archiveFlowNodeInstance(flowNodeInstance, false, this.processDefinitionId);
        activityInstanceService.setState(flowNodeInstance, flowNodeStateManager.getFailedState());
    }

    public String getFlowNodeInstanceName() {
        return this.flowNodeInstanceName;
    }

    public long getParentFlowNodeInstanceId() {
        return this.parentFlowNodeInstanceId;
    }
}

