/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.commons.ClassReflector;
import org.bonitasoft.engine.commons.exceptions.SReflectException;
import org.bonitasoft.engine.expression.ContainerState;
import org.bonitasoft.engine.expression.NonEmptyContentExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.ExpressionKind;
import org.bonitasoft.engine.expression.model.SExpression;

public class JavaMethodCallExpressionExecutorStrategy
extends NonEmptyContentExpressionExecutorStrategy {
    @Override
    public Object evaluate(SExpression expression, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionEvaluationException {
        SExpression dependency = expression.getDependencies().get(0);
        Object object = resolvedExpressions.get(dependency.getDiscriminant());
        try {
            return ClassReflector.invokeGetter(object, expression.getContent());
        }
        catch (SReflectException e) {
            throw new SExpressionEvaluationException((Throwable)e, expression.getName());
        }
    }

    @Override
    public void validate(SExpression expression) throws SInvalidExpressionException {
        super.validate(expression);
        if (expression.getDependencies() == null || expression.getDependencies().size() != 1) {
            throw new SInvalidExpressionException("An expression of type TYPE_JAVA_METHOD_CALL must have exactly one dependency. This dependency represents the object where the method will be called. Expression :" + expression, expression.getName());
        }
    }

    @Override
    public ExpressionKind getExpressionKind() {
        return KIND_JAVA_METHOD_CALL;
    }

    @Override
    public List<Object> evaluate(List<SExpression> expressions, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionEvaluationException {
        ArrayList<Object> result = new ArrayList<Object>(2);
        for (SExpression expression : expressions) {
            result.add(this.evaluate(expression, context, resolvedExpressions, containerState));
        }
        return result;
    }

    @Override
    public boolean mustPutEvaluatedExpressionInContext() {
        return false;
    }
}

