/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.operation;

import org.bonitasoft.engine.bpm.document.DocumentValue;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.LeftOperandHandler;
import org.bonitasoft.engine.core.operation.exception.SOperationExecutionException;
import org.bonitasoft.engine.core.operation.model.SLeftOperand;
import org.bonitasoft.engine.core.process.document.api.ProcessDocumentService;
import org.bonitasoft.engine.core.process.document.model.SProcessDocument;
import org.bonitasoft.engine.core.process.document.model.builder.SProcessDocumentBuilder;
import org.bonitasoft.engine.core.process.document.model.builder.SProcessDocumentBuilderFactory;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.document.SDocumentNotFoundException;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.sessionaccessor.SessionIdNotSetException;

public class DocumentLeftOperandHandler
implements LeftOperandHandler {
    ProcessDocumentService processDocumentService;
    private final ActivityInstanceService activityInstanceService;
    private final SessionAccessor sessionAccessor;
    private final SessionService sessionService;

    public DocumentLeftOperandHandler(ProcessDocumentService processDocumentService, ActivityInstanceService activityInstanceService, SessionAccessor sessionAccessor, SessionService sessionService) {
        this.processDocumentService = processDocumentService;
        this.activityInstanceService = activityInstanceService;
        this.sessionAccessor = sessionAccessor;
        this.sessionService = sessionService;
    }

    @Override
    public Object update(SLeftOperand sLeftOperand, Object newValue, long containerId, String containerType) throws SOperationExecutionException {
        boolean isDocumentWithContent = newValue instanceof DocumentValue;
        if (!isDocumentWithContent && newValue != null) {
            throw new SOperationExecutionException("Document operation only accepts an expression returning a DocumentValue and not " + newValue.getClass().getName());
        }
        String documentName = sLeftOperand.getName();
        try {
            long processInstanceId;
            if (DataInstanceContainer.PROCESS_INSTANCE.name().equals(containerType)) {
                processInstanceId = containerId;
            } else {
                SFlowNodeInstance flowNodeInstance = this.activityInstanceService.getFlowNodeInstance(containerId);
                processInstanceId = flowNodeInstance.getParentProcessInstanceId();
            }
            if (newValue == null) {
                try {
                    this.processDocumentService.removeCurrentVersion(processInstanceId, documentName);
                }
                catch (SDocumentNotFoundException e) {}
            } else {
                long authorId;
                try {
                    long sessionId = this.sessionAccessor.getSessionId();
                    authorId = this.sessionService.getSession(sessionId).getUserId();
                }
                catch (SessionIdNotSetException e) {
                    authorId = -1L;
                }
                DocumentValue documentValue = (DocumentValue)newValue;
                boolean hasContent = documentValue.hasContent();
                try {
                    this.processDocumentService.getDocument(processInstanceId, documentName);
                    SProcessDocument document = this.createDocument(documentName, processInstanceId, authorId, documentValue, hasContent, documentValue.getUrl());
                    if (hasContent) {
                        this.processDocumentService.updateDocumentOfProcessInstance(document, documentValue.getContent());
                    } else {
                        this.processDocumentService.updateDocumentOfProcessInstance(document);
                    }
                }
                catch (SDocumentNotFoundException e) {
                    SProcessDocument document = this.createDocument(documentName, processInstanceId, authorId, documentValue, hasContent, documentValue.getUrl());
                    if (hasContent) {
                        this.processDocumentService.attachDocumentToProcessInstance(document, documentValue.getContent());
                    }
                    this.processDocumentService.attachDocumentToProcessInstance(document);
                }
            }
            return newValue;
        }
        catch (SBonitaException e) {
            throw new SOperationExecutionException(e);
        }
    }

    private SProcessDocument createDocument(String documentName, long processInstanceId, long authorId, DocumentValue documentValue, boolean hasContent, String documentUrl) {
        SProcessDocumentBuilder processDocumentBuilder = BuilderFactory.get(SProcessDocumentBuilderFactory.class).createNewInstance();
        processDocumentBuilder.setName(documentName);
        processDocumentBuilder.setFileName(documentValue.getFileName());
        processDocumentBuilder.setContentMimeType(documentValue.getMimeType());
        processDocumentBuilder.setProcessInstanceId(processInstanceId);
        processDocumentBuilder.setAuthor(authorId);
        processDocumentBuilder.setCreationDate(System.currentTimeMillis());
        processDocumentBuilder.setHasContent(hasContent);
        processDocumentBuilder.setURL(documentUrl);
        return processDocumentBuilder.done();
    }

    @Override
    public String getType() {
        return "DOCUMENT";
    }

    @Override
    public void delete(SLeftOperand leftOperand, long containerId, String containerType) throws SOperationExecutionException {
        throw new SOperationExecutionException("Deleting a document is not supported");
    }

    @Override
    public Object retrieve(SLeftOperand sLeftOperand, SExpressionContext expressionContext) {
        return null;
    }

    @Override
    public boolean supportBatchUpdate() {
        return true;
    }
}

