/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.persistence;

import org.bonitasoft.engine.persistence.PersistentObject;

public abstract class AbstractSelectDescriptor<T> {
    private final String queryName;
    private final Class<? extends PersistentObject> entityType;
    private final Class<T> returnType;

    public AbstractSelectDescriptor(String queryName, Class<? extends PersistentObject> entityType, Class<T> returnType) {
        this.entityType = entityType;
        this.queryName = queryName;
        this.returnType = returnType;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public Class<? extends PersistentObject> getEntityType() {
        return this.entityType;
    }

    public Class<T> getReturnType() {
        return this.returnType;
    }

    public String toString() {
        return "AbstractSelectDescriptor [entityType=" + this.entityType + ", queryName=" + this.queryName + ", returnType=" + this.returnType + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entityType == null ? 0 : this.entityType.hashCode());
        result = 31 * result + (this.queryName == null ? 0 : this.queryName.hashCode());
        result = 31 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSelectDescriptor other = (AbstractSelectDescriptor)obj;
        if (this.entityType == null ? other.entityType != null : !this.entityType.equals(other.entityType)) {
            return false;
        }
        if (this.queryName == null ? other.queryName != null : !this.queryName.equals(other.queryName)) {
            return false;
        }
        return !(this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType));
    }
}

