/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.work;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.work.BonitaExecutorService;
import org.bonitasoft.engine.work.BonitaExecutorServiceFactory;
import org.bonitasoft.engine.work.BonitaThreadPoolExecutor;
import org.bonitasoft.engine.work.WorkerThreadFactory;

public class DefaultBonitaExecutorServiceFactory
implements BonitaExecutorServiceFactory {
    private final int corePoolSize;
    private final int queueCapacity;
    private final int maximumPoolSize;
    private final long keepAliveTimeSeconds;
    private final TechnicalLoggerService logger;
    private final long tenantId;

    public DefaultBonitaExecutorServiceFactory(TechnicalLoggerService logger, long tenantId, int corePoolSize, int queueCapacity, int maximumPoolSize, long keepAliveTimeSeconds) {
        this.logger = logger;
        this.tenantId = tenantId;
        this.corePoolSize = corePoolSize;
        this.queueCapacity = queueCapacity;
        this.maximumPoolSize = maximumPoolSize;
        this.keepAliveTimeSeconds = keepAliveTimeSeconds;
    }

    @Override
    public BonitaExecutorService createExecutorService() {
        ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(this.queueCapacity);
        QueueRejectedExecutionHandler handler = new QueueRejectedExecutionHandler();
        WorkerThreadFactory threadFactory = new WorkerThreadFactory("Bonita-Worker", this.tenantId, this.maximumPoolSize);
        return new BonitaThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTimeSeconds, TimeUnit.SECONDS, workQueue, threadFactory, handler, this.logger);
    }

    private final class QueueRejectedExecutionHandler
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
            if (!executor.isShutdown()) {
                throw new RejectedExecutionException("Unable to run the task " + task + "\n your work queue is full you might consider changing your configuration to scale more. See parameter 'queueCapacity' in bonita.home configuration files.");
            }
            DefaultBonitaExecutorServiceFactory.this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Tried to run work " + task + " but the work service is shutdown. work will be restarted with the node");
        }
    }
}

