/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import org.bonitasoft.engine.api.PermissionAPI;
import org.bonitasoft.engine.api.permission.APICallContext;
import org.bonitasoft.engine.commons.exceptions.SExecutionException;
import org.bonitasoft.engine.exception.ExecutionException;
import org.bonitasoft.engine.exception.NotFoundException;
import org.bonitasoft.engine.service.PermissionService;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceSingleton;

public class PermissionAPIImpl
implements PermissionAPI {
    public boolean checkAPICallWithScript(String className, APICallContext context, boolean reload) throws ExecutionException, NotFoundException {
        TenantServiceAccessor serviceAccessor = this.getTenantServiceAccessor();
        PermissionService permissionService = serviceAccessor.getPermissionService();
        try {
            return permissionService.checkAPICallWithScript(className, context, reload);
        }
        catch (SExecutionException e) {
            throw new ExecutionException("Unable to execute the security rule " + className + " for the api call " + context, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new NotFoundException("Unable to execute the security rule " + className + " for the api call " + context + "because the class " + className + " is not found", (Throwable)e);
        }
    }

    TenantServiceAccessor getTenantServiceAccessor() {
        return TenantServiceSingleton.getInstance();
    }
}

