/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.identity.CustomUserInfoValue;
import org.bonitasoft.engine.identity.CustomUserInfoValueUpdater;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SIdentityException;
import org.bonitasoft.engine.identity.model.SCustomUserInfoValue;
import org.bonitasoft.engine.identity.model.builder.SCustomUserInfoValueBuilderFactory;
import org.bonitasoft.engine.identity.model.builder.SCustomUserInfoValueUpdateBuilderFactory;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.search.descriptor.SearchEntityDescriptor;
import org.bonitasoft.engine.search.identity.SearchCustomUserInfoValues;

public class SCustomUserInfoValueAPI {
    private final SCustomUserInfoValueBuilderFactory creatorFactory;
    private final SCustomUserInfoValueUpdateBuilderFactory updaterFactory;
    private final IdentityService service;

    public SCustomUserInfoValueAPI(IdentityService service, SCustomUserInfoValueBuilderFactory creatorFactory, SCustomUserInfoValueUpdateBuilderFactory updaterFactory) {
        this.creatorFactory = creatorFactory;
        this.updaterFactory = updaterFactory;
        this.service = service;
    }

    public SearchResult<CustomUserInfoValue> search(SearchEntityDescriptor descriptor, SearchOptions options) throws SBonitaException {
        SearchCustomUserInfoValues search = new SearchCustomUserInfoValues(this.service, descriptor, options);
        search.execute();
        return search.getResult();
    }

    public SCustomUserInfoValue update(SCustomUserInfoValue value, CustomUserInfoValueUpdater updater) throws SIdentityException {
        this.assertNoNull("Cannot update a value based on null parameters", value, updater);
        this.service.updateCustomUserInfoValue(value, this.updaterFactory.createNewInstance().updateValue(updater.getValue()).done());
        return this.service.getCustomUserInfoValue(value.getId());
    }

    public SCustomUserInfoValue set(long definitionId, long userId, String value) throws SIdentityException, SBonitaReadException {
        SCustomUserInfoValue customUserInfoValue = this.searchValue(definitionId, userId);
        if (value == null || value.isEmpty()) {
            this.delete(customUserInfoValue);
            return this.createValue(definitionId, userId, value);
        }
        if (customUserInfoValue != null) {
            return this.update(customUserInfoValue, new CustomUserInfoValueUpdater(value));
        }
        return this.create(definitionId, userId, value);
    }

    public SCustomUserInfoValue create(long definitionId, long userId, String value) throws SIdentityException {
        return this.service.createCustomUserInfoValue(this.createValue(definitionId, userId, value));
    }

    public void delete(SCustomUserInfoValue value) throws SIdentityException {
        if (value != null) {
            this.service.deleteCustomUserInfoValue(value);
        }
    }

    private SCustomUserInfoValue createValue(long definitionId, long userId, String value) {
        return this.creatorFactory.createNewInstance().setDefinitionId(definitionId).setUserId(userId).setValue(value).done();
    }

    private SCustomUserInfoValue searchValue(long definitionId, long userId) throws SBonitaReadException {
        List<SCustomUserInfoValue> result = this.service.searchCustomUserInfoValue(new QueryOptions(0, 1, Collections.<OrderByOption>emptyList(), Arrays.asList(new FilterOption(SCustomUserInfoValue.class, this.creatorFactory.getDefinitionIdKey(), definitionId), new FilterOption(SCustomUserInfoValue.class, this.creatorFactory.getUserIdKey(), userId)), null));
        if (result.size() == 0) {
            return null;
        }
        return result.get(0);
    }

    private void assertNoNull(String message, Object ... objects) {
        for (Object object : objects) {
            if (object != null) continue;
            throw new IllegalArgumentException(message);
        }
    }
}

