/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import org.bonitasoft.engine.api.internal.ServerAPI;
import org.bonitasoft.engine.home.BonitaHomeServer;

public class ServerAPIFactory {
    private static final String SERVER_API_CLASS_NOT_FOUND = "Cannot load class %s. Platform property 'serverApi' may not be set.";
    private static ServerAPIFactory _instance;
    private final BonitaHomeServer bonitaHomeServer;

    ServerAPIFactory(BonitaHomeServer bonitaHomeServer) {
        this.bonitaHomeServer = bonitaHomeServer;
    }

    public static ServerAPI getServerAPI() {
        return ServerAPIFactory.getInstance().getServerAPIImplementation();
    }

    public static ServerAPI getServerAPI(boolean cleanSession) {
        return ServerAPIFactory.getInstance().getServerAPIImplementation(cleanSession);
    }

    ServerAPI getServerAPIImplementation() {
        String serverAPIClassName = this.bonitaHomeServer.getServerAPIImplementation();
        try {
            return (ServerAPI)Class.forName(serverAPIClassName).newInstance();
        }
        catch (RuntimeException e) {
            throw new ExceptionInInitializerError(String.format(SERVER_API_CLASS_NOT_FOUND, serverAPIClassName));
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(String.format(SERVER_API_CLASS_NOT_FOUND, serverAPIClassName));
        }
    }

    ServerAPI getServerAPIImplementation(boolean cleanSession) {
        String serverAPIClassName = this.bonitaHomeServer.getServerAPIImplementation();
        try {
            Class<?> serverApiClass = Class.forName(serverAPIClassName);
            return (ServerAPI)serverApiClass.getConstructor(Boolean.TYPE).newInstance(cleanSession);
        }
        catch (RuntimeException e) {
            throw new ExceptionInInitializerError(String.format(SERVER_API_CLASS_NOT_FOUND, serverAPIClassName));
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(String.format(SERVER_API_CLASS_NOT_FOUND, serverAPIClassName));
        }
    }

    public static ServerAPIFactory getInstance() {
        if (_instance == null) {
            ServerAPIFactory.initializeFactorySingleton();
        }
        return _instance;
    }

    private static synchronized void initializeFactorySingleton() {
        if (_instance == null) {
            _instance = new ServerAPIFactory(BonitaHomeServer.getInstance());
        }
    }
}

