/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.actor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.model.SActor;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;

public class GetActorInitiators
implements TransactionContentWithResult<List<SActor>> {
    private final ActorMappingService actorMappingService;
    private final Set<Long> actorIds;
    private final List<SActor> sActors = new ArrayList<SActor>();

    public GetActorInitiators(ActorMappingService actorMappingService, Set<Long> actorIds) {
        this.actorMappingService = actorMappingService;
        this.actorIds = actorIds;
    }

    @Override
    public void execute() throws SBonitaException {
        Iterator<Long> iterator = this.actorIds.iterator();
        while (iterator.hasNext()) {
            SActor sActor = this.actorMappingService.getActor(iterator.next());
            if (!sActor.isInitiator()) continue;
            this.sActors.add(sActor);
        }
    }

    @Override
    public List<SActor> getResult() {
        return this.sActors;
    }
}

