/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.actor;

import java.util.Set;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SActorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;

public class GetNumberOfActors
implements TransactionContentWithResult<Integer> {
    private final ProcessDefinitionService processDefinitionService;
    private final long processDefinitionId;
    private int numberOfActors;

    public GetNumberOfActors(ProcessDefinitionService processDefinitionService, long processDefinitionId) {
        this.processDefinitionService = processDefinitionService;
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public void execute() throws SBonitaException {
        SProcessDefinition definition = this.processDefinitionService.getProcessDefinition(this.processDefinitionId);
        SActorDefinition actorInitiator = definition.getActorInitiator();
        Set<SActorDefinition> actors = definition.getActors();
        this.numberOfActors = actors.size();
        if (actorInitiator != null && !actors.contains(actorInitiator)) {
            ++this.numberOfActors;
        }
    }

    @Override
    public Integer getResult() {
        return this.numberOfActors;
    }
}

