/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.expression;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.api.impl.transaction.expression.AbstractEvaluateExpressionsInstance;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SExpressionTypeUnknownException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.service.ModelConvertor;

public class EvaluateExpressionsDefinitionLevel
extends AbstractEvaluateExpressionsInstance
implements TransactionContentWithResult<Map<String, Serializable>> {
    private final Map<Expression, Map<String, Serializable>> expressionsAndTheirPartialContext;
    private final long processDefinitionId;
    private final ExpressionResolverService expressionResolver;
    private final ProcessDefinitionService processDefinitionService;
    private final Map<String, Serializable> results = new HashMap<String, Serializable>(0);

    public EvaluateExpressionsDefinitionLevel(Map<Expression, Map<String, Serializable>> expressions, long processDefinitionId, ExpressionResolverService expressionResolverService, ProcessDefinitionService processDefinitionService) {
        this.expressionsAndTheirPartialContext = expressions;
        this.processDefinitionId = processDefinitionId;
        this.expressionResolver = expressionResolverService;
        this.processDefinitionService = processDefinitionService;
    }

    @Override
    public void execute() throws SBonitaException {
        if (this.expressionsAndTheirPartialContext != null && !this.expressionsAndTheirPartialContext.isEmpty()) {
            SExpressionContext context = new SExpressionContext();
            if (this.processDefinitionId != 0L) {
                SProcessDefinition processDefinition = this.processDefinitionService.getProcessDefinition(this.processDefinitionId);
                Set<Expression> exps = this.expressionsAndTheirPartialContext.keySet();
                for (Expression exp : exps) {
                    Map<String, Serializable> inputValues = this.getPartialContext(this.expressionsAndTheirPartialContext, exp);
                    if (inputValues == null) {
                        inputValues = new HashMap<String, Serializable>();
                    }
                    inputValues.put("processDefinition", processDefinition);
                    context.setProcessDefinitionId(this.processDefinitionId);
                    context.setSerializableInputValues(inputValues);
                    SExpression sexp = ModelConvertor.constructSExpression(exp);
                    Serializable res = this.evaluateExpression(context, sexp, processDefinition);
                    this.results.put(this.buildName(exp), res);
                }
            }
        }
    }

    protected Serializable evaluateExpression(SExpressionContext context, SExpression sexp, SProcessDefinition processDefinition) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException {
        try {
            return (Serializable)this.expressionResolver.evaluate(sexp, context);
        }
        catch (SExpressionTypeUnknownException e) {
            throw this.enrichExceptionContext(e, processDefinition);
        }
        catch (SExpressionEvaluationException e) {
            throw this.enrichExceptionContext(e, processDefinition);
        }
        catch (SExpressionDependencyMissingException e) {
            throw this.enrichExceptionContext(e, processDefinition);
        }
        catch (SInvalidExpressionException e) {
            throw this.enrichExceptionContext(e, processDefinition);
        }
    }

    private <T extends SBonitaException> T enrichExceptionContext(T e, SProcessDefinition processDefinition) {
        e.setProcessDefinitionIdOnContext(processDefinition.getId());
        e.setProcessDefinitionNameOnContext(processDefinition.getName());
        e.setProcessDefinitionVersionOnContext(processDefinition.getVersion());
        return e;
    }

    @Override
    public Map<String, Serializable> getResult() {
        return this.results;
    }
}

