/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.identity;

import java.util.List;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.model.SUserMembership;
import org.bonitasoft.engine.identity.model.builder.SUserMembershipBuilderFactory;

public class AddUserMemberships
implements TransactionContent {
    private final List<Long> userIds;
    private final IdentityService identityService;
    private final long groupId;
    private final long roleId;
    private final long currentUserId;

    public AddUserMemberships(long groupId, long roleId, List<Long> userIds, IdentityService identityService, long currentUserId) {
        this.groupId = groupId;
        this.roleId = roleId;
        this.userIds = userIds;
        this.identityService = identityService;
        this.currentUserId = currentUserId;
    }

    @Override
    public void execute() throws SBonitaException {
        for (long userId : this.userIds) {
            SUserMembership userMembership = BuilderFactory.get(SUserMembershipBuilderFactory.class).createNewInstance(userId, this.groupId, this.roleId).setAssignedBy(this.currentUserId).done();
            this.identityService.createUserMembership(userMembership);
        }
    }
}

