/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.identity;

import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.api.impl.transaction.identity.DeleteWithActorMembers;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SUserNotFoundException;
import org.bonitasoft.engine.profile.ProfileService;

public class DeleteUser
extends DeleteWithActorMembers
implements TransactionContent {
    private final long userId;
    private final String userName;

    public DeleteUser(IdentityService identityService, ActorMappingService actorMappingService, ProfileService profileService, long userId) {
        super(actorMappingService, profileService, identityService);
        this.userId = userId;
        this.userName = null;
    }

    public DeleteUser(IdentityService identityService, ActorMappingService actorMappingService, ProfileService profileService, String userName) {
        super(actorMappingService, profileService, identityService);
        this.userId = -1L;
        this.userName = userName;
    }

    @Override
    public void execute() throws SBonitaException {
        try {
            long id = this.userId;
            if (id == -1L) {
                id = this.getIdentityService().getUserByUserName(this.userName).getId();
            }
            this.deleteUserMembershipsByUser(id);
            this.deleteActorMembersOfUser(id);
            this.deleteProfileMembersOfUser(id);
            this.getIdentityService().deleteUser(id);
        }
        catch (SUserNotFoundException sUserNotFoundException) {
            // empty catch block
        }
    }
}

