/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.process;

import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SStartEventDefinition;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventModificationException;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingEvent;
import org.bonitasoft.engine.execution.job.JobNameBuilder;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.scheduler.SchedulerService;
import org.bonitasoft.engine.scheduler.exception.SSchedulerException;

public final class DisableProcess
implements TransactionContent {
    private final ProcessDefinitionService processDefinitionService;
    private final EventInstanceService eventInstanceService;
    private final long processDefinitionId;
    private final SchedulerService scheduler;
    private final TechnicalLoggerService logger;
    private final String username;

    public DisableProcess(ProcessDefinitionService processDefinitionService, long processId, EventInstanceService eventInstanceService, SchedulerService scheduler, TechnicalLoggerService logger, String username) {
        this.processDefinitionService = processDefinitionService;
        this.eventInstanceService = eventInstanceService;
        this.processDefinitionId = processId;
        this.scheduler = scheduler;
        this.logger = logger;
        this.username = username;
    }

    @Override
    public void execute() throws SBonitaException {
        this.processDefinitionService.disableProcessDeploymentInfo(this.processDefinitionId);
        SProcessDefinition processDefinition = this.processDefinitionService.getProcessDefinition(this.processDefinitionId);
        this.disableStartEvents(processDefinition);
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "The user <" + this.username + "> has disabled process <" + processDefinition.getName() + "> in version <" + processDefinition.getVersion() + "> with id <" + processDefinition.getId() + ">");
        }
    }

    private void disableStartEvents(SProcessDefinition processDefinition) throws SBonitaException {
        this.deleteWaitingEvents();
        this.deleteJobs(processDefinition);
    }

    private void deleteJobs(SProcessDefinition processDefinition) throws SSchedulerException {
        List<SStartEventDefinition> startEvents = processDefinition.getProcessContainer().getStartEvents();
        for (SStartEventDefinition startEvent : startEvents) {
            if (startEvent.getTimerEventTriggerDefinitions().isEmpty()) continue;
            this.scheduler.delete(JobNameBuilder.getTimerEventJobName(this.processDefinitionId, startEvent, null));
        }
    }

    private void deleteWaitingEvents() throws SWaitingEventModificationException, SBonitaReadException {
        QueryOptions queryOptions = new QueryOptions(0, 100, SWaitingEvent.class, "id", OrderByType.ASC);
        List<SWaitingEvent> waitingEvents = this.eventInstanceService.searchStartWaitingEvents(this.processDefinitionId, queryOptions);
        while (!waitingEvents.isEmpty()) {
            for (SWaitingEvent startEvent : waitingEvents) {
                this.eventInstanceService.deleteWaitingEvent(startEvent);
            }
            waitingEvents = this.eventInstanceService.searchStartWaitingEvents(this.processDefinitionId, queryOptions);
        }
    }
}

