/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.cache.ehcache;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.cache.CacheConfigurations;
import org.bonitasoft.engine.cache.CacheService;
import org.bonitasoft.engine.cache.SCacheException;
import org.bonitasoft.engine.cache.ehcache.CommonEhCacheCacheService;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.sessionaccessor.ReadSessionAccessor;
import org.bonitasoft.engine.sessionaccessor.STenantIdNotSetException;

public class EhCacheCacheService
extends CommonEhCacheCacheService
implements CacheService {
    public EhCacheCacheService(TechnicalLoggerService logger, ReadSessionAccessor sessionAccessor, CacheConfigurations cacheConfigurations, URL configFile) {
        super(logger, sessionAccessor, cacheConfigurations, configFile);
    }

    public EhCacheCacheService(TechnicalLoggerService logger, ReadSessionAccessor sessionAccessor, CacheConfigurations cacheConfigurations) {
        super(logger, sessionAccessor, cacheConfigurations);
    }

    @Override
    protected String getKeyFromCacheName(String cacheName) throws SCacheException {
        try {
            return String.valueOf(this.sessionAccessor.getTenantId()) + '_' + cacheName;
        }
        catch (STenantIdNotSetException e) {
            throw new SCacheException(e);
        }
    }

    @Override
    public List<String> getCachesNames() {
        if (this.cacheManager == null) {
            return Collections.emptyList();
        }
        String[] cacheNames = this.cacheManager.getCacheNames();
        ArrayList<String> cacheNamesList = new ArrayList<String>(cacheNames.length);
        try {
            String prefix = String.valueOf(this.sessionAccessor.getTenantId()) + '_';
            for (String cacheName : cacheNames) {
                if (!cacheName.startsWith(prefix)) continue;
                cacheNamesList.add(this.getCacheNameFromKey(cacheName));
            }
        }
        catch (STenantIdNotSetException e) {
            throw new RuntimeException(e);
        }
        return cacheNamesList;
    }

    private String getCacheNameFromKey(String cacheNameKey) {
        return cacheNameKey.substring(cacheNameKey.indexOf(95) + 1);
    }
}

