/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.category.model.xml;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.core.category.model.SCategory;
import org.bonitasoft.engine.core.category.model.xml.XMLCategoryMapping;
import org.bonitasoft.engine.core.category.model.xml.XMLProcessDefinitionsMapping;

public class XMLCategoriesMapping {
    private List<XMLCategoryMapping> categoryMappingList;

    public XMLCategoriesMapping() {
        this.categoryMappingList = new ArrayList<XMLCategoryMapping>();
    }

    public XMLCategoriesMapping(List<XMLCategoryMapping> categoryMappings) {
        this.categoryMappingList = categoryMappings;
    }

    public List<XMLCategoryMapping> getCategoryList() {
        return this.categoryMappingList;
    }

    public void addCategory(XMLCategoryMapping categoryMapping) {
        if (this.categoryMappingList == null) {
            this.categoryMappingList = new ArrayList<XMLCategoryMapping>();
        }
        this.categoryMappingList.add(categoryMapping);
    }

    public void deleteCategory(String name) {
        for (int i = 0; i < this.categoryMappingList.size(); ++i) {
            if (!this.categoryMappingList.get(i).getName().equals(name)) continue;
            this.categoryMappingList.remove(i);
        }
    }

    public XMLCategoryMapping getCategory(String name) {
        for (XMLCategoryMapping categoryMapping : this.categoryMappingList) {
            if (!categoryMapping.getName().equals(name)) continue;
            return categoryMapping;
        }
        return null;
    }

    public List<XMLCategoryMapping> getCategoriesByProcessDefinitionId(String processDefinitionId) {
        ArrayList<XMLCategoryMapping> categoryMappings = null;
        for (XMLCategoryMapping categoryMapping : this.categoryMappingList) {
            if (!categoryMapping.getProcessDefinitions().contains(processDefinitionId)) continue;
            if (categoryMappings == null) {
                categoryMappings = new ArrayList<XMLCategoryMapping>();
            }
            categoryMappings.add(categoryMapping);
        }
        return categoryMappings;
    }

    public XMLProcessDefinitionsMapping getProcessDefinitions(String categoryName) {
        for (XMLCategoryMapping categoryMapping : this.categoryMappingList) {
            if (!categoryMapping.getName().equals(categoryName)) continue;
            return categoryMapping.getProcessDefinitions();
        }
        return null;
    }

    public void updateCategory(String categoryName, SCategory newCategory) {
        XMLCategoryMapping categoryMapping = this.getCategory(categoryName);
        categoryMapping.update(newCategory);
    }

    public boolean contains(XMLCategoryMapping xmlCategoryMapping) {
        return this.categoryMappingList.contains(xmlCategoryMapping);
    }

    public void removeProcessDefiniton(String processDefinitionId) {
        for (XMLCategoryMapping categoryMapping : this.categoryMappingList) {
            if (!categoryMapping.getProcessDefinitions().contains(processDefinitionId)) continue;
            categoryMapping.deleteProcessDefinition(processDefinitionId);
        }
    }
}

