/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.expression.control.api.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.classloader.SClassLoaderException;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionReadException;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.expression.ContainerState;
import org.bonitasoft.engine.expression.ExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.ExpressionService;
import org.bonitasoft.engine.expression.ExpressionType;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SExpressionTypeUnknownException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.ExpressionKind;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.tracking.TimeTracker;

public class ExpressionResolverServiceImpl
implements ExpressionResolverService {
    private static final SExpressionContext EMPTY_CONTEXT = new SExpressionContext();
    private final ExpressionService expressionService;
    private final ProcessDefinitionService processDefinitionService;
    private final ClassLoaderService classLoaderService;
    private final TimeTracker timeTracker;

    public ExpressionResolverServiceImpl(ExpressionService expressionService, ProcessDefinitionService processDefinitionService, ClassLoaderService classLoaderService, TimeTracker timeTracker) {
        this.expressionService = expressionService;
        this.processDefinitionService = processDefinitionService;
        this.classLoaderService = classLoaderService;
        this.timeTracker = timeTracker;
    }

    @Override
    public Object evaluate(SExpression expression) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException {
        return this.evaluate(expression, EMPTY_CONTEXT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(SExpression expression, SExpressionContext evaluationContext) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException {
        long startTime = System.currentTimeMillis();
        try {
            Object object = this.evaluateExpressionsFlatten(Collections.singletonList(expression), evaluationContext).get(0);
            return object;
        }
        finally {
            if (this.timeTracker.isTrackable("EVALUATE_EXPRESSION_INCLUDING_CONTEXT")) {
                long endTime = System.currentTimeMillis();
                StringBuilder desc = new StringBuilder();
                desc.append("Expression: ");
                desc.append(expression);
                desc.append(" - ");
                desc.append("evaluationContext: ");
                desc.append(evaluationContext);
                this.timeTracker.track("EVALUATE_EXPRESSION_INCLUDING_CONTEXT", desc.toString(), endTime - startTime);
            }
        }
    }

    private List<Object> evaluateExpressionsFlatten(List<SExpression> expressions, SExpressionContext evaluationContext) throws SInvalidExpressionException, SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        SExpressionContext newEvaluationContext = EMPTY_CONTEXT;
        try {
            Long processDefinitionId;
            HashMap<String, Object> dependencyValues = new HashMap<String, Object>();
            if (evaluationContext != null) {
                newEvaluationContext = evaluationContext;
                this.fillContext(newEvaluationContext, dependencyValues);
            }
            if ((processDefinitionId = newEvaluationContext.getProcessDefinitionId()) != null) {
                Thread.currentThread().setContextClassLoader(this.classLoaderService.getLocalClassLoader("PROCESS", processDefinitionId));
            }
            HashMap<SExpression, SExpression> dataReplacement = new HashMap<SExpression, SExpression>();
            HashMap<Integer, Object> resolvedExpressions = new HashMap<Integer, Object>();
            resolvedExpressions.putAll(this.evaluateAllExpressionsWithNoDependencies(dependencyValues, dataReplacement, expressions, newEvaluationContext));
            for (SExpression sExpression : expressions) {
                if (sExpression == null) continue;
                resolvedExpressions.putAll(this.evaluateExpressionWithResolvedDependencies(sExpression, dependencyValues, dataReplacement, resolvedExpressions, newEvaluationContext.getContainerState()));
            }
            ArrayList<Object> results = new ArrayList<Object>(expressions.size());
            for (SExpression sExpression : expressions) {
                if (sExpression != null) {
                    int key = sExpression.getDiscriminant();
                    Object res = resolvedExpressions.get(key);
                    if (res == null && !resolvedExpressions.containsKey(key)) {
                        throw new SExpressionEvaluationException("No result found for the expression " + sExpression, sExpression.getName());
                    }
                    results.add(res);
                    continue;
                }
                results.add(null);
            }
            ArrayList<Object> arrayList = results;
            return arrayList;
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw this.buildSExpressionEvaluationExceptionWhenNotFindProcess(newEvaluationContext, e);
        }
        catch (SProcessDefinitionReadException e) {
            throw this.buildSExpressionEvaluationExceptionWhenNotFindProcess(newEvaluationContext, e);
        }
        catch (SClassLoaderException e) {
            throw new SExpressionEvaluationException((Throwable)e, null);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private SExpressionEvaluationException buildSExpressionEvaluationExceptionWhenNotFindProcess(SExpressionContext evaluationContext, SBonitaException e) {
        SExpressionEvaluationException exception = new SExpressionEvaluationException("The process definition was not found.", e, null);
        exception.setProcessDefinitionIdOnContext(evaluationContext.getProcessDefinitionId());
        return exception;
    }

    private Map<Integer, Object> evaluateAllExpressionsWithNoDependencies(Map<String, Object> dependencyValues, Map<SExpression, SExpression> dataReplacement, List<SExpression> expressions, SExpressionContext evaluationContext) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException {
        SExpression expressionNotProvided;
        HashMap<Integer, Object> resolvedExpressions = new HashMap<Integer, Object>();
        Map<ExpressionKind, List<SExpression>> expressionMapByKind = this.flattenDependencies(expressions);
        List<SExpression> variableExpressions = expressionMapByKind.get(new ExpressionKind(ExpressionType.TYPE_VARIABLE.name()));
        if (evaluationContext.isEvaluateInDefinition() && variableExpressions != null && !variableExpressions.isEmpty() && (expressionNotProvided = this.variablesAreAllProvided(variableExpressions, evaluationContext)) != null) {
            throw new SExpressionEvaluationException("Evaluation of expressions of type VARIABLE is forbidden at process definition level.", expressionNotProvided.getName());
        }
        for (ExpressionKind kind : ExpressionExecutorStrategy.NO_DEPENDENCY_EXPRESSION_EVALUATION_ORDER) {
            resolvedExpressions.putAll(this.evaluateExpressionsOfKind(dependencyValues, expressionMapByKind.get(kind), kind, dataReplacement, resolvedExpressions, evaluationContext.getContainerState()));
            expressionMapByKind.remove(kind);
        }
        return resolvedExpressions;
    }

    private SExpression variablesAreAllProvided(List<SExpression> variableExpressions, SExpressionContext evaluationContext) {
        Iterator<SExpression> iterator = variableExpressions.iterator();
        Map<String, Object> inputValues = evaluationContext.getInputValues();
        while (iterator.hasNext()) {
            SExpression next = iterator.next();
            if (inputValues.containsKey(next.getContent())) continue;
            return next;
        }
        return null;
    }

    private Map<? extends Integer, ? extends Object> evaluateExpressionWithResolvedDependencies(SExpression sExpression, Map<String, Object> dependencyValues, Map<SExpression, SExpression> dataReplacement, Map<Integer, Object> alreadyResolvedExpressions, ContainerState containerState) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException {
        HashMap<Integer, Object> resolvedExpressions = new HashMap<Integer, Object>(alreadyResolvedExpressions);
        for (SExpression dep : sExpression.getDependencies()) {
            resolvedExpressions.putAll(this.evaluateExpressionWithResolvedDependencies(dep, dependencyValues, dataReplacement, resolvedExpressions, containerState));
        }
        if (!resolvedExpressions.containsKey(sExpression.getDiscriminant())) {
            Object exprResult = this.expressionService.evaluate(sExpression, dependencyValues, resolvedExpressions, containerState);
            this.addResultToMap(resolvedExpressions, dataReplacement, sExpression, exprResult, dependencyValues);
        }
        return resolvedExpressions;
    }

    private Map<Integer, Object> evaluateExpressionsOfKind(Map<String, Object> dependencyValues, List<SExpression> expressionsOfKind, ExpressionKind kind, Map<SExpression, SExpression> dataReplacement, Map<Integer, Object> alreadyResolvedExpressions, ContainerState containerState) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException {
        HashMap<Integer, Object> resolvedExpressions = new HashMap<Integer, Object>();
        if (expressionsOfKind != null) {
            List<Object> evaluationResults = this.expressionService.evaluate(kind, expressionsOfKind, dependencyValues, alreadyResolvedExpressions, containerState);
            Iterator<SExpression> variableIterator = expressionsOfKind.iterator();
            for (Object evaluationResult : evaluationResults) {
                SExpression expression = variableIterator.next();
                this.addResultToMap(resolvedExpressions, dataReplacement, expression, evaluationResult, dependencyValues);
            }
        }
        return resolvedExpressions;
    }

    private void addResultToMap(Map<Integer, Object> resolvedExpressions, Map<SExpression, SExpression> dataReplacement, SExpression expression, Object expressionResult, Map<String, Object> dependencyValues) {
        SExpression replacement;
        resolvedExpressions.put(expression.getDiscriminant(), expressionResult);
        if (this.expressionService.mustPutEvaluatedExpressionInContext(expression.getExpressionKind())) {
            dependencyValues.put(expression.getContent(), expressionResult);
        }
        if ((replacement = dataReplacement.get(expression)) != null) {
            resolvedExpressions.put(replacement.getDiscriminant(), expressionResult);
            if (this.expressionService.mustPutEvaluatedExpressionInContext(expression.getExpressionKind())) {
                dependencyValues.put(replacement.getContent(), expressionResult);
            }
        }
    }

    private Map<ExpressionKind, List<SExpression>> flattenDependencies(Collection<SExpression> collection) {
        HashMap<ExpressionKind, List<SExpression>> expressionMapByKind = new HashMap<ExpressionKind, List<SExpression>>();
        for (SExpression sExpression : collection) {
            if (sExpression == null) continue;
            ExpressionKind expressionKind = sExpression.getExpressionKind();
            ArrayList<SExpression> exprList = (ArrayList<SExpression>)expressionMapByKind.get(expressionKind);
            if (exprList == null) {
                exprList = new ArrayList<SExpression>();
                expressionMapByKind.put(expressionKind, exprList);
            }
            if (!exprList.contains(sExpression)) {
                exprList.add(sExpression);
            }
            if (sExpression.getDependencies() == null) continue;
            expressionMapByKind.putAll(this.flattenDependencies(sExpression.getDependencies()));
        }
        return expressionMapByKind;
    }

    private void fillContext(SExpressionContext evaluationContext, Map<String, Object> dependencyValues) throws SProcessDefinitionNotFoundException, SProcessDefinitionReadException {
        if (evaluationContext.getContainerId() == null && evaluationContext.getProcessDefinitionId() != null) {
            SProcessDefinition processDefinition = this.processDefinitionService.getProcessDefinition(evaluationContext.getProcessDefinitionId());
            evaluationContext.setProcessDefinition(processDefinition);
            evaluationContext.setEvaluateInDefinition(true);
        }
        if (evaluationContext.getContainerId() != null) {
            dependencyValues.put("containerId", evaluationContext.getContainerId());
        }
        if (evaluationContext.getContainerType() != null) {
            dependencyValues.put("containerType", evaluationContext.getContainerType());
        }
        if (evaluationContext.getProcessDefinitionId() != null) {
            dependencyValues.put("processDefinitionId", evaluationContext.getProcessDefinitionId());
        }
        if (evaluationContext.getTime() != 0L) {
            dependencyValues.put("time", evaluationContext.getTime());
        }
        if (evaluationContext.getInputValues() != null) {
            dependencyValues.putAll(evaluationContext.getInputValues());
        }
    }

    @Override
    public List<Object> evaluate(List<SExpression> expressions, SExpressionContext contextDependency) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException {
        return this.evaluateExpressionsFlatten(expressions, contextDependency);
    }
}

