/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.instance.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.CollectionUtil;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.connector.ConnectorInstanceService;
import org.bonitasoft.engine.core.connector.exception.SConnectorInstanceDeletionException;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeDeletionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.STaskVisibilityException;
import org.bonitasoft.engine.core.process.instance.impl.FlowNodeInstancesServiceImpl;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SHiddenTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SHumanTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SLoopActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SMultiInstanceActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SPendingActivityMapping;
import org.bonitasoft.engine.core.process.instance.model.archive.SAActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAHumanTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.builder.SHiddenTaskInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SHiddenTaskInstanceLogBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SHiddenTaskInstanceLogBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SMultiInstanceActivityInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SPendingActivityMappingLogBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SPendingActivityMappingLogBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SUserTaskInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.recorder.SelectDescriptorBuilder;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.persistence.search.FilterOperationType;
import org.bonitasoft.engine.queriablelogger.model.builder.ActionType;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteAllRecord;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;
import org.bonitasoft.engine.services.PersistenceService;

public class ActivityInstanceServiceImpl
extends FlowNodeInstancesServiceImpl
implements ActivityInstanceService {
    private static final String ASSIGNED_AND_PENDING_BY_ROOT_PROCESS = "AssignedAndPendingByRootProcess";
    private static final String ASSIGNED_AND_PENDING_BY_ROOT_PROCESS_FOR = "AssignedAndPendingByRootProcessFor";
    private static final String SUPERVISED_BY = "SupervisedBy";
    private static final String MANAGED_BY = "ManagedBy";
    private static final String PENDING_MANAGED_BY = "PendingManagedBy";
    private static final String PENDING_SUPERVISED_BY = "PendingSupervisedBy";
    private static final String PENDING_HIDDEN_FOR_USER = "PendingHiddenForUser";
    private static final String PENDING_FOR_USER = "PendingForUser";
    private static final String PENDING_OR_ASSIGNED = "PendingOrAssigned";
    private static final String ACTIVITYINSTANCE_ASSIGNEE = "ACTIVITYINSTANCE_ASSIGNEE";
    private static final String WHOCANSTART_PENDING_TASK_SUFFIX = "WhoCanStartPendingTask";
    private static final int BATCH_SIZE = 100;
    private final SUserTaskInstanceBuilderFactory sUserTaskInstanceBuilder;
    private final SMultiInstanceActivityInstanceBuilderFactory sMultiInstanceActivityInstanceBuilder;
    private final DataInstanceService dataInstanceService;
    private final ConnectorInstanceService connectorInstanceService;

    public ActivityInstanceServiceImpl(Recorder recorder, PersistenceService persistenceService, ArchiveService archiveService, DataInstanceService dataInstanceService, ConnectorInstanceService connectorInstanceService, EventService eventService, TechnicalLoggerService logger) {
        super(recorder, persistenceService, eventService, logger, archiveService);
        this.dataInstanceService = dataInstanceService;
        this.connectorInstanceService = connectorInstanceService;
        this.sUserTaskInstanceBuilder = BuilderFactory.get(SUserTaskInstanceBuilderFactory.class);
        this.sMultiInstanceActivityInstanceBuilder = BuilderFactory.get(SMultiInstanceActivityInstanceBuilderFactory.class);
    }

    @Override
    public void createActivityInstance(SActivityInstance activityInstance) throws SActivityCreationException {
        try {
            InsertRecord insertRecord = new InsertRecord(activityInstance);
            SInsertEvent insertEvent = null;
            if (this.getEventService().hasHandlers("ACTIVITYINSTANCE", EventActionType.CREATED)) {
                insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("ACTIVITYINSTANCE").setObject(activityInstance).done();
            }
            this.getRecorder().recordInsert(insertRecord, insertEvent);
        }
        catch (SRecorderException e) {
            throw new SActivityCreationException(e);
        }
        if (this.getLogger().isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            StringBuilder stb = new StringBuilder();
            stb.append("Created ");
            stb.append(activityInstance.getType().getValue());
            stb.append(" <");
            stb.append(activityInstance.getName());
            stb.append("> with id = <");
            stb.append(activityInstance.getId());
            if (activityInstance.getParentActivityInstanceId() > 0L) {
                stb.append(">, parent activity instance id = <");
                stb.append(activityInstance.getParentActivityInstanceId());
            }
            stb.append(">, parent process instance id = <");
            stb.append(activityInstance.getParentProcessInstanceId());
            stb.append(">, root process instance id = <");
            stb.append(activityInstance.getRootProcessInstanceId());
            stb.append(">, process definition id = <");
            stb.append(activityInstance.getProcessDefinitionId());
            stb.append(">");
            this.getLogger().log(this.getClass(), TechnicalLogSeverity.DEBUG, stb.toString());
        }
    }

    protected SPendingActivityMappingLogBuilder getQueriableLog(ActionType actionType, String message, SPendingActivityMapping mapping) {
        SPendingActivityMappingLogBuilder logBuilder = BuilderFactory.get(SPendingActivityMappingLogBuilderFactory.class).createNewInstance();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        logBuilder.activityInstanceId(mapping.getActivityId());
        return logBuilder;
    }

    @Override
    public void addPendingActivityMappings(SPendingActivityMapping mapping) throws SActivityCreationException {
        InsertRecord insertRecord = new InsertRecord(mapping);
        EventService eventService = this.getEventService();
        SInsertEvent insertEvent = null;
        if (eventService.hasHandlers("PENDINGACTIVITYMAPPING", EventActionType.CREATED)) {
            insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("PENDINGACTIVITYMAPPING").setObject(mapping).done();
        }
        try {
            this.getRecorder().recordInsert(insertRecord, insertEvent);
        }
        catch (SRecorderException e) {
            throw new SActivityCreationException(e);
        }
    }

    @Override
    public void deletePendingMappings(long humanTaskInstanceId) throws SActivityModificationException {
        try {
            List<SPendingActivityMapping> mappings = null;
            boolean createEvents = this.getEventService().hasHandlers("PENDINGACTIVITYMAPPING", EventActionType.DELETED);
            QueryOptions queryOptions = new QueryOptions(0, 100, SPendingActivityMapping.class, "id", OrderByType.ASC);
            while (!(mappings = this.getPendingMappings(humanTaskInstanceId, queryOptions)).isEmpty()) {
                this.deletePendingMappings(mappings, createEvents);
            }
        }
        catch (SBonitaException e) {
            throw new SActivityModificationException(e);
        }
    }

    private void deletePendingMappings(List<SPendingActivityMapping> mappings, boolean createEvents) throws SRecorderException {
        for (SPendingActivityMapping mapping : mappings) {
            this.deletePendingMapping(mapping, createEvents);
        }
    }

    private void deletePendingMapping(SPendingActivityMapping mapping, boolean createEvents) throws SRecorderException {
        SDeleteEvent deleteEvent = null;
        if (createEvents) {
            deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("PENDINGACTIVITYMAPPING").setObject(mapping).done();
        }
        this.getRecorder().recordDelete(new DeleteRecord(mapping), deleteEvent);
    }

    @Override
    public void deleteAllPendingMappings() throws SActivityModificationException {
        try {
            FilterOption filterOption = new FilterOption(SPendingActivityMapping.class, "actorId", -1);
            DeleteAllRecord record = new DeleteAllRecord(SPendingActivityMapping.class, Collections.singletonList(filterOption));
            this.getRecorder().recordDeleteAll(record);
        }
        catch (SRecorderException e) {
            throw new SActivityModificationException("Can't delete all pending mappings not attached to an actor.", e);
        }
    }

    @Override
    public List<SPendingActivityMapping> getPendingMappings(long humanTaskInstanceId, QueryOptions queryOptions) throws SBonitaReadException {
        Map<String, Object> parameters = CollectionUtil.buildSimpleMap("activityId", humanTaskInstanceId);
        return this.getPersistenceService().selectList(new SelectListDescriptor("getPendingMappingsOfTask", parameters, SPendingActivityMapping.class, queryOptions));
    }

    @Override
    public SActivityInstance getActivityInstance(long activityInstanceId) throws SActivityInstanceNotFoundException, SBonitaReadException {
        SActivityInstance activity = this.getPersistenceService().selectById(SelectDescriptorBuilder.getElementById(SActivityInstance.class, "SActivityInstance", activityInstanceId));
        if (activity == null) {
            throw new SActivityInstanceNotFoundException(activityInstanceId);
        }
        return activity;
    }

    @Override
    public SHumanTaskInstance getHumanTaskInstance(long activityInstanceId) throws SActivityInstanceNotFoundException, SBonitaReadException {
        SelectByIdDescriptor<SHumanTaskInstance> descriptor = SelectDescriptorBuilder.getElementById(SHumanTaskInstance.class, "SHumanTaskInstance", activityInstanceId);
        SHumanTaskInstance humanTask = this.getPersistenceService().selectById(descriptor);
        if (humanTask == null) {
            throw new SActivityInstanceNotFoundException(activityInstanceId);
        }
        return humanTask;
    }

    @Override
    public List<SActivityInstance> getActivitiesWithStates(long rootContainerId, Set<Integer> stateIds, int fromIndex, int maxResults, String sortingField, OrderByType sortingOrder) throws SBonitaReadException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("rootContainerId", rootContainerId);
        parameters.put("stateIds", stateIds);
        SelectListDescriptor<SActivityInstance> elements = SelectDescriptorBuilder.getSpecificQueryWithParameters(SActivityInstance.class, "getActivitiesWithStates", parameters, new QueryOptions(fromIndex, maxResults, SActivityInstance.class, sortingField, sortingOrder));
        return this.getPersistenceService().selectList(elements);
    }

    @Override
    public List<SActivityInstance> getOpenActivityInstances(long rootContainerId, int pageIndex, int maxResults, String sortingField, OrderByType orderbyType) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("rootContainerId", rootContainerId);
        QueryOptions queryOptions = new QueryOptions(pageIndex * maxResults, maxResults, SActivityInstance.class, sortingField, orderbyType);
        SelectListDescriptor<SActivityInstance> elements = SelectDescriptorBuilder.getSpecificQueryWithParameters(SActivityInstance.class, "getOpenActivitiesFromProcessInstance", parameters, queryOptions);
        return this.getPersistenceService().selectList(elements);
    }

    @Override
    public SAActivityInstance getMostRecentArchivedActivityInstance(long activityInstanceId) throws SBonitaReadException, SActivityInstanceNotFoundException {
        SelectOneDescriptor<SAActivityInstance> descriptor;
        ReadPersistenceService persistenceService = this.getArchiveService().getDefinitiveArchiveReadPersistenceService();
        SAActivityInstance activity = persistenceService.selectOne(descriptor = SelectDescriptorBuilder.getMostRecentArchivedActivityInstance(activityInstanceId));
        if (activity == null) {
            throw new SActivityInstanceNotFoundException(activityInstanceId);
        }
        return activity;
    }

    @Override
    public List<SAActivityInstance> getArchivedActivityInstances(long rootContainerId, QueryOptions queryOptions) throws SBonitaReadException {
        ReadPersistenceService persistenceService = this.getArchiveService().getDefinitiveArchiveReadPersistenceService();
        List<SAActivityInstance> activities = persistenceService.selectList(SelectDescriptorBuilder.getArchivedActivitiesFromProcessInstance(rootContainerId, queryOptions));
        return this.getUnmodifiableList(activities);
    }

    @Override
    public List<SHumanTaskInstance> getPendingTasks(long userId, Set<Long> actorIds, int fromIndex, int maxResults, String sortFieldName, OrderByType order) throws SBonitaReadException {
        SelectListDescriptor<SHumanTaskInstance> selectListDescriptor = actorIds.isEmpty() ? SelectDescriptorBuilder.getPendingUserTasks(userId, fromIndex, maxResults, sortFieldName, order) : SelectDescriptorBuilder.getPendingUserTasks(userId, actorIds, fromIndex, maxResults, sortFieldName, order);
        return this.getPersistenceService().selectList(selectListDescriptor);
    }

    @Override
    public List<SHumanTaskInstance> getAssignedUserTasks(long assigneeId, int fromIndex, int maxResults, String sortFieldName, OrderByType order) throws SBonitaReadException {
        SelectListDescriptor<SHumanTaskInstance> selectListDescriptor = SelectDescriptorBuilder.getAssignedUserTasks(assigneeId, fromIndex, maxResults, sortFieldName, order);
        return this.getPersistenceService().selectList(selectListDescriptor);
    }

    @Override
    public int getNumberOfOpenActivityInstances(long rootContainerId) throws SBonitaReadException {
        return this.getPersistenceService().selectOne(SelectDescriptorBuilder.getNumberOfOpenActivities(rootContainerId)).intValue();
    }

    @Override
    public List<SActivityInstance> getActivityInstances(long rootContainerId, int fromIndex, int numberOfResults) throws SBonitaReadException {
        SelectListDescriptor<SActivityInstance> descriptor = SelectDescriptorBuilder.getActivitiesFromProcessInstance(rootContainerId, fromIndex, numberOfResults);
        List<SActivityInstance> selectList = this.getPersistenceService().selectList(descriptor);
        return this.getUnmodifiableList(selectList);
    }

    @Override
    public int getNumberOfActivityInstances(long rootContainerId) throws SBonitaReadException {
        return this.getPersistenceService().selectOne(SelectDescriptorBuilder.getNumberOfActivitiesFromProcessInstance(rootContainerId)).intValue();
    }

    @Override
    public void assignHumanTask(long userTaskId, long userId) throws SFlowNodeNotFoundException, SFlowNodeReadException, SActivityModificationException {
        SFlowNodeInstance flowNodeInstance = this.getFlowNodeInstance(userTaskId);
        if (flowNodeInstance instanceof SHumanTaskInstance) {
            EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
            descriptor.addField(this.sUserTaskInstanceBuilder.getAssigneeIdKey(), userId);
            if (userId > 0L) {
                descriptor.addField(this.sUserTaskInstanceBuilder.getClaimedDateKey(), System.currentTimeMillis());
            } else {
                descriptor.addField(this.sUserTaskInstanceBuilder.getClaimedDateKey(), 0);
            }
            UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)flowNodeInstance, descriptor);
            SUpdateEvent updateEvent = null;
            if (this.getEventService().hasHandlers(ACTIVITYINSTANCE_ASSIGNEE, EventActionType.UPDATED)) {
                updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent(ACTIVITYINSTANCE_ASSIGNEE).setObject(flowNodeInstance).done();
            }
            try {
                this.getRecorder().recordUpdate(updateRecord, updateEvent);
            }
            catch (SRecorderException e) {
                throw new SActivityModificationException(e);
            }
        } else {
            throw new SActivityReadException("the activity with id " + userTaskId + " is not a user task");
        }
    }

    @Override
    public long getNumberOfAssignedHumanTaskInstances(long userId) throws SBonitaReadException {
        return this.getPersistenceService().selectOne(SelectDescriptorBuilder.getNumberOfAssignedHumanTaskInstances(userId));
    }

    @Override
    public SAActivityInstance getArchivedActivityInstance(long activityInstanceId, int stateId) throws SBonitaReadException, SActivityInstanceNotFoundException {
        ReadPersistenceService persistenceService = this.getArchiveService().getDefinitiveArchiveReadPersistenceService();
        SAActivityInstance selectOne = persistenceService.selectOne(SelectDescriptorBuilder.getArchivedActivityInstanceWithActivityIdAndStateId(activityInstanceId, stateId));
        if (selectOne == null) {
            throw new SActivityInstanceNotFoundException(activityInstanceId, stateId);
        }
        return selectOne;
    }

    @Override
    public long getNumberOfArchivedTasksManagedBy(long managerUserId, QueryOptions searchOptions) throws SBonitaReadException {
        ReadPersistenceService persistenceService = this.getArchiveService().getDefinitiveArchiveReadPersistenceService();
        Map<String, Object> parameters = Collections.singletonMap("managerUserId", managerUserId);
        return persistenceService.getNumberOfEntities(SAHumanTaskInstance.class, MANAGED_BY, searchOptions, parameters);
    }

    @Override
    public List<SAHumanTaskInstance> searchArchivedTasksManagedBy(long managerUserId, QueryOptions searchOptions) throws SBonitaReadException {
        ReadPersistenceService persistenceService = this.getArchiveService().getDefinitiveArchiveReadPersistenceService();
        Map<String, Object> parameters = Collections.singletonMap("managerUserId", managerUserId);
        return persistenceService.searchEntity(SAHumanTaskInstance.class, MANAGED_BY, searchOptions, parameters);
    }

    @Override
    public long getNumberOfArchivedHumanTasksSupervisedBy(long supervisorId, QueryOptions queryOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("supervisorId", supervisorId);
        return this.getPersistenceService().getNumberOfEntities(SAHumanTaskInstance.class, SUPERVISED_BY, queryOptions, parameters);
    }

    @Override
    public long getNumberOfAssignedTasksSupervisedBy(long supervisorId, QueryOptions queryOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("supervisorId", supervisorId);
        queryOptions.getFilters().add(new FilterOption(SHumanTaskInstance.class, "assigneeId", (Object)0, FilterOperationType.GREATER));
        return this.getPersistenceService().getNumberOfEntities(SHumanTaskInstance.class, SUPERVISED_BY, queryOptions, parameters);
    }

    @Override
    public List<SHumanTaskInstance> searchAssignedTasksSupervisedBy(long supervisorId, QueryOptions queryOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("supervisorId", supervisorId);
        queryOptions.getFilters().add(new FilterOption(SHumanTaskInstance.class, "assigneeId", (Object)0, FilterOperationType.GREATER));
        return this.getPersistenceService().searchEntity(SHumanTaskInstance.class, SUPERVISED_BY, queryOptions, parameters);
    }

    @Override
    public long getNumberOfHumanTasks(QueryOptions queryOptions) throws SBonitaReadException {
        return this.getPersistenceService().getNumberOfEntities(SHumanTaskInstance.class, queryOptions, null);
    }

    @Override
    public List<SHumanTaskInstance> searchHumanTasks(QueryOptions queryOptions) throws SBonitaReadException {
        return this.getPersistenceService().searchEntity(SHumanTaskInstance.class, queryOptions, null);
    }

    @Override
    public List<SAHumanTaskInstance> searchArchivedHumanTasksSupervisedBy(long supervisorId, QueryOptions queryOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("supervisorId", supervisorId);
        return this.getPersistenceService().searchEntity(SAHumanTaskInstance.class, SUPERVISED_BY, queryOptions, parameters);
    }

    @Override
    public List<SAHumanTaskInstance> searchArchivedTasks(QueryOptions searchOptions) throws SBonitaReadException {
        ReadPersistenceService persistenceService = this.getArchiveService().getDefinitiveArchiveReadPersistenceService();
        return persistenceService.searchEntity(SAHumanTaskInstance.class, searchOptions, null);
    }

    @Override
    public long getNumberOfArchivedTasks(QueryOptions searchOptions) throws SBonitaReadException {
        ReadPersistenceService persistenceService = this.getArchiveService().getDefinitiveArchiveReadPersistenceService();
        return persistenceService.getNumberOfEntities(SAHumanTaskInstance.class, searchOptions, null);
    }

    @Override
    public long getNumberOfAssignedTasksManagedBy(long managerUserId, QueryOptions searchOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("managerUserId", managerUserId);
        return this.getPersistenceService().getNumberOfEntities(SHumanTaskInstance.class, MANAGED_BY, searchOptions, parameters);
    }

    @Override
    public List<SHumanTaskInstance> searchAssignedTasksManagedBy(long managerUserId, QueryOptions searchOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("managerUserId", managerUserId);
        return this.getPersistenceService().searchEntity(SHumanTaskInstance.class, MANAGED_BY, searchOptions, parameters);
    }

    @Override
    public List<SHumanTaskInstance> searchPendingTasksSupervisedBy(long supervisorId, QueryOptions queryOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("userId", supervisorId);
        return this.getPersistenceService().searchEntity(SHumanTaskInstance.class, PENDING_SUPERVISED_BY, queryOptions, parameters);
    }

    @Override
    public long getNumberOfPendingTasksSupervisedBy(long supervisorId, QueryOptions queryOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("userId", supervisorId);
        return this.getPersistenceService().getNumberOfEntities(SHumanTaskInstance.class, PENDING_SUPERVISED_BY, queryOptions, parameters);
    }

    @Override
    public Map<Long, Long> getNumberOfOpenTasksForUsers(List<Long> userIds) throws SBonitaReadException {
        if (userIds == null || userIds.size() == 0) {
            return Collections.emptyMap();
        }
        List<Map<String, Long>> result = this.getPersistenceService().selectList(SelectDescriptorBuilder.getNumbersOfAssignedOpenTasks(userIds));
        HashMap<Long, Long> userTaskNumbermap = new HashMap<Long, Long>();
        for (Map<String, Long> record : result) {
            userTaskNumbermap.put(record.get("userId"), record.get("numberOfTasks"));
        }
        for (Long userId : userIds) {
            long pendingCount = this.getNumberOfPendingTasksForUser(userId, new QueryOptions(0, Integer.MAX_VALUE));
            if (!userTaskNumbermap.containsKey(userId)) {
                userTaskNumbermap.put(userId, pendingCount);
                continue;
            }
            userTaskNumbermap.put(userId, (Long)userTaskNumbermap.get(userId) + pendingCount);
        }
        return userTaskNumbermap;
    }

    @Override
    public long searchNumberOfPendingTasksManagedBy(long managerUserId, QueryOptions searchOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("managerUserId", managerUserId);
        return this.getPersistenceService().getNumberOfEntities(SHumanTaskInstance.class, PENDING_MANAGED_BY, searchOptions, parameters);
    }

    @Override
    public List<SHumanTaskInstance> searchPendingTasksManagedBy(long managerUserId, QueryOptions searchOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("managerUserId", managerUserId);
        return this.getPersistenceService().searchEntity(SHumanTaskInstance.class, PENDING_MANAGED_BY, searchOptions, parameters);
    }

    @Override
    public void incrementLoopCounter(SLoopActivityInstance loopInstance) throws SActivityModificationException {
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField("loopCounter", loopInstance.getLoopCounter() + 1);
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)loopInstance, descriptor);
        SUpdateEvent updateEvent = null;
        if (this.getEventService().hasHandlers("ACTIVITYINSTANCE_STATE", EventActionType.UPDATED)) {
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("ACTIVITYINSTANCE_STATE").setObject(loopInstance).done();
        }
        try {
            this.getRecorder().recordUpdate(updateRecord, updateEvent);
        }
        catch (SRecorderException sre) {
            throw new SActivityModificationException(sre);
        }
    }

    @Override
    public Map<Long, Long> getNumberOfOverdueOpenTasksForUsers(List<Long> userIds) throws SBonitaReadException {
        if (userIds == null || userIds.size() == 0) {
            return Collections.emptyMap();
        }
        List<Map<Long, Long>> result = this.getPersistenceService().selectList(SelectDescriptorBuilder.getNumbersOfAssignedOverdueOpenTasks(userIds));
        HashMap<Long, Long> userTaskNumbermap = new HashMap<Long, Long>();
        for (Map<Long, Long> record : result) {
            userTaskNumbermap.put(record.get("userId"), record.get("numberOfTasks"));
        }
        for (Long userId : userIds) {
            long pendingCount = this.getPersistenceService().selectOne(SelectDescriptorBuilder.getNumberOfPendingOverdueOpenTasksForUser(userId));
            if (!userTaskNumbermap.containsKey(userId)) {
                userTaskNumbermap.put(userId, pendingCount);
                continue;
            }
            userTaskNumbermap.put(userId, (Long)userTaskNumbermap.get(userId) + pendingCount);
        }
        return userTaskNumbermap;
    }

    @Override
    public List<SActivityInstance> getChildrenOfAnActivity(long parentActivityInstanceId, int fromIndex, int numberOfResults) throws SBonitaReadException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("parentActivityInstanceId", parentActivityInstanceId);
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfResults, SFlowNodeInstance.class, "id", OrderByType.ASC);
        SelectListDescriptor descriptor = new SelectListDescriptor("getChildrenOfAnActivity", parameters, SActivityInstance.class, queryOptions);
        return this.getPersistenceService().selectList(descriptor);
    }

    @Override
    public void setLoopMax(SLoopActivityInstance loopActivity, Integer loopMap) throws SFlowNodeModificationException {
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField("loopMax", loopMap);
        this.updateFlowNode(loopActivity, "LOOPINSTANCE_LOOPMAX_MODIFIED", descriptor);
    }

    @Override
    public void setLoopCardinality(SFlowNodeInstance flowNodeInstance, int intLoopCardinality) throws SFlowNodeModificationException {
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(this.sMultiInstanceActivityInstanceBuilder.getLoopCardinalityKey(), intLoopCardinality);
        this.updateFlowNode(flowNodeInstance, "MULTIINSTANCE_LOOPMAX_MODIFIED", descriptor);
    }

    @Override
    public void addMultiInstanceNumberOfActiveActivities(SMultiInstanceActivityInstance flowNodeInstance, int number) throws SFlowNodeModificationException {
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(this.sMultiInstanceActivityInstanceBuilder.getNumberOfActiveInstancesKey(), flowNodeInstance.getNumberOfActiveInstances() + number);
        this.updateFlowNode(flowNodeInstance, "MULTIINSTANCE_LOOPMAX_MODIFIED", descriptor);
    }

    @Override
    public void addMultiInstanceNumberOfTerminatedActivities(SMultiInstanceActivityInstance flowNodeInstance, int number) throws SFlowNodeModificationException {
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(this.sMultiInstanceActivityInstanceBuilder.getNumberOfActiveInstancesKey(), flowNodeInstance.getNumberOfActiveInstances() - number);
        descriptor.addField(this.sMultiInstanceActivityInstanceBuilder.getNumberOfTerminatedInstancesKey(), flowNodeInstance.getNumberOfTerminatedInstances() + number);
        this.updateFlowNode(flowNodeInstance, "MULTIINSTANCE_LOOPMAX_MODIFIED", descriptor);
    }

    @Override
    public void addMultiInstanceNumberOfCompletedActivities(SMultiInstanceActivityInstance flowNodeInstance, int number) throws SFlowNodeModificationException {
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(this.sMultiInstanceActivityInstanceBuilder.getNumberOfActiveInstancesKey(), flowNodeInstance.getNumberOfActiveInstances() - number);
        descriptor.addField(this.sMultiInstanceActivityInstanceBuilder.getNumberOfCompletedInstancesKey(), flowNodeInstance.getNumberOfCompletedInstances() + number);
        this.updateFlowNode(flowNodeInstance, "MULTIINSTANCE_LOOPMAX_MODIFIED", descriptor);
    }

    @Override
    public long getNumberOfActivityInstances(Class<? extends PersistentObject> entityClass, QueryOptions searchOptions) throws SBonitaReadException {
        return this.getPersistenceService().getNumberOfEntities(entityClass, searchOptions, null);
    }

    @Override
    public List<SActivityInstance> searchActivityInstances(Class<? extends PersistentObject> entityClass, QueryOptions searchOptions) throws SBonitaReadException {
        return this.getPersistenceService().searchEntity(entityClass, searchOptions, null);
    }

    @Override
    public long getNumberOfArchivedActivityInstances(Class<? extends PersistentObject> entityClass, QueryOptions searchOptions) throws SBonitaReadException {
        ReadPersistenceService persistenceService = this.getArchiveService().getDefinitiveArchiveReadPersistenceService();
        return persistenceService.getNumberOfEntities(entityClass, searchOptions, null);
    }

    @Override
    public List<SAActivityInstance> searchArchivedActivityInstances(Class<? extends PersistentObject> entityClass, QueryOptions searchOptions) throws SBonitaReadException {
        ReadPersistenceService persistenceService = this.getArchiveService().getDefinitiveArchiveReadPersistenceService();
        return persistenceService.searchEntity(entityClass, searchOptions, null);
    }

    @Override
    public void setTokenCount(SActivityInstance activityInstance, int tokenCount) throws SFlowNodeModificationException {
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(this.sUserTaskInstanceBuilder.getTokenCountKey(), tokenCount);
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)activityInstance, descriptor);
        SUpdateEvent updateEvent = null;
        if (this.getEventService().hasHandlers("ACTIVITY_INSTANCE_TOKEN_COUNT", EventActionType.UPDATED)) {
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("ACTIVITY_INSTANCE_TOKEN_COUNT").setObject(activityInstance).done();
        }
        try {
            this.getRecorder().recordUpdate(updateRecord, updateEvent);
        }
        catch (SRecorderException e) {
            throw new SFlowNodeModificationException(e);
        }
    }

    @Override
    public void hideTasks(long userId, Long ... activityInstanceId) throws SActivityInstanceNotFoundException, STaskVisibilityException, SBonitaReadException {
        Long[] arr$ = activityInstanceId;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            long id = arr$[i$];
            this.hideTask(userId, id);
        }
    }

    private void hideTask(long userId, long activityInstanceId) throws SActivityInstanceNotFoundException, STaskVisibilityException, SBonitaReadException {
        this.getHumanTaskInstance(activityInstanceId);
        SHiddenTaskInstance hiddenTask = BuilderFactory.get(SHiddenTaskInstanceBuilderFactory.class).createNewInstance(activityInstanceId, userId).done();
        InsertRecord insertRecord = new InsertRecord(hiddenTask);
        EventService eventService = this.getEventService();
        SInsertEvent insertEvent = null;
        if (eventService.hasHandlers("HIDDENTASK", EventActionType.CREATED)) {
            insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("HIDDENTASK").setObject(hiddenTask).done();
        }
        try {
            this.getRecorder().recordInsert(insertRecord, insertEvent);
        }
        catch (SRecorderException e) {
            throw new STaskVisibilityException("Can't hide the task.", activityInstanceId, userId);
        }
    }

    @Override
    public void unhideTasks(long userId, Long ... activityInstanceId) throws STaskVisibilityException {
        for (Long actId : activityInstanceId) {
            this.unhideTask(userId, actId);
        }
    }

    @Override
    public void unhideTask(long userId, long activityInstanceId) throws STaskVisibilityException {
        SHiddenTaskInstance hiddenTask = this.getHiddenTask(userId, activityInstanceId);
        try {
            DeleteRecord deleteRecord = new DeleteRecord(hiddenTask);
            SDeleteEvent deleteEvent = null;
            if (this.getEventService().hasHandlers("HIDDENTASK", EventActionType.DELETED)) {
                deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("HIDDENTASK").setObject(hiddenTask).done();
            }
            this.getRecorder().recordDelete(deleteRecord, deleteEvent);
        }
        catch (SRecorderException e) {
            throw new STaskVisibilityException("Can't unhide the task.", hiddenTask.getActivityId(), hiddenTask.getUserId(), e);
        }
    }

    @Override
    public SHiddenTaskInstance getHiddenTask(long userId, long activityInstanceId) throws STaskVisibilityException {
        try {
            SHiddenTaskInstance hiddenTask = this.getPersistenceService().selectOne(SelectDescriptorBuilder.getSHiddenTask(userId, activityInstanceId));
            if (hiddenTask == null) {
                throw new STaskVisibilityException("SHiddenTaskInstance not found.", activityInstanceId, userId);
            }
            return hiddenTask;
        }
        catch (SBonitaReadException e) {
            throw new STaskVisibilityException("SHiddenTaskInstance not found.", activityInstanceId, userId, e);
        }
    }

    @Override
    public SHiddenTaskInstance getHiddenTask(long id) throws STaskVisibilityException, SBonitaReadException {
        SHiddenTaskInstance hiddenTask = this.getPersistenceService().selectById(SelectDescriptorBuilder.getElementById(SHiddenTaskInstance.class, "SHiddenTaskInstance", id));
        if (hiddenTask == null) {
            throw new STaskVisibilityException("SHiddenTaskInstance not found.", id);
        }
        return hiddenTask;
    }

    @Override
    public List<SHiddenTaskInstance> searchHiddenTasksForActivity(long activityInstanceId, int fromIndex, int maxResults) throws STaskVisibilityException {
        try {
            return this.getPersistenceService().selectList(SelectDescriptorBuilder.getSHiddenTasksForActivity(activityInstanceId, fromIndex, maxResults));
        }
        catch (SBonitaReadException e) {
            throw new STaskVisibilityException("Error searching for hidden tasks for the activity.", activityInstanceId, e);
        }
    }

    @Override
    public void deleteHiddenTasksForActivity(long activityInstanceId) throws STaskVisibilityException {
        List<SHiddenTaskInstance> hiddenTasks;
        while (!(hiddenTasks = this.searchHiddenTasksForActivity(activityInstanceId, 0, 100)).isEmpty()) {
            for (SHiddenTaskInstance sHiddenTask : hiddenTasks) {
                this.unhideTasks(sHiddenTask.getUserId(), activityInstanceId);
            }
        }
    }

    @Override
    public void deleteAllHiddenTasks() throws STaskVisibilityException {
        try {
            DeleteAllRecord record = new DeleteAllRecord(SHiddenTaskInstance.class, null);
            this.getRecorder().recordDeleteAll(record);
        }
        catch (SRecorderException e) {
            throw new STaskVisibilityException("Can't delete all hidden tasks.", e);
        }
    }

    @Override
    public long getNumberOfPendingHiddenTasks(long userId, QueryOptions queryOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("userId", userId);
        return this.getPersistenceService().getNumberOfEntities(SHumanTaskInstance.class, PENDING_HIDDEN_FOR_USER, queryOptions, parameters);
    }

    @Override
    public List<SHumanTaskInstance> searchPendingHiddenTasks(long userId, QueryOptions queryOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("userId", userId);
        return this.getPersistenceService().searchEntity(SHumanTaskInstance.class, PENDING_HIDDEN_FOR_USER, queryOptions, parameters);
    }

    protected SHiddenTaskInstanceLogBuilder getHiddenTaskQueriableLog(ActionType actionType, String message, SHiddenTaskInstance hiddenTask) {
        SHiddenTaskInstanceLogBuilder logBuilder = BuilderFactory.get(SHiddenTaskInstanceLogBuilderFactory.class).createNewInstance();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        logBuilder.activityInstanceId(hiddenTask.getActivityId());
        logBuilder.userId(hiddenTask.getUserId());
        return logBuilder;
    }

    @Override
    public long getNumberOfPendingTasksForUser(long userId, QueryOptions searchOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("userId", userId);
        return this.getPersistenceService().getNumberOfEntities(SHumanTaskInstance.class, PENDING_FOR_USER, searchOptions, parameters);
    }

    @Override
    public List<SHumanTaskInstance> searchPendingTasksForUser(long userId, QueryOptions searchOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("userId", userId);
        return this.getPersistenceService().searchEntity(SHumanTaskInstance.class, PENDING_FOR_USER, searchOptions, parameters);
    }

    @Override
    public long getNumberOfPendingOrAssignedTasks(long userId, QueryOptions searchOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("userId", userId);
        return this.getPersistenceService().getNumberOfEntities(SHumanTaskInstance.class, PENDING_OR_ASSIGNED, searchOptions, parameters);
    }

    @Override
    public List<SHumanTaskInstance> searchPendingOrAssignedTasks(long userId, QueryOptions searchOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("userId", userId);
        return this.getPersistenceService().searchEntity(SHumanTaskInstance.class, PENDING_OR_ASSIGNED, searchOptions, parameters);
    }

    @Override
    public boolean isTaskHidden(long userId, long activityInstanceId) throws SBonitaReadException {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("activityId", activityInstanceId);
        parameters.put("userId", userId);
        Long selectOne = this.getPersistenceService().selectOne(new SelectOneDescriptor<Long>("isTaskHidden", parameters, SHiddenTaskInstance.class, Long.class));
        return selectOne == 1L;
    }

    @Override
    public void deleteArchivedPendingMappings(long flowNodeInstanceId) {
    }

    @Override
    public void setAbortedByBoundaryEvent(SActivityInstance activityInstance, long boundaryEventId) throws SActivityModificationException {
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(this.sUserTaskInstanceBuilder.getAbortedByBoundaryEventIdKey(), boundaryEventId);
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)activityInstance, descriptor);
        SUpdateEvent updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("STATE_CATEGORY").setObject(activityInstance).done();
        try {
            this.getRecorder().recordUpdate(updateRecord, updateEvent);
        }
        catch (SRecorderException sre) {
            throw new SActivityModificationException(sre);
        }
    }

    @Override
    public List<Long> getPossibleUserIdsOfPendingTasks(long humanTaskInstanceId, int startIndex, int maxResults) throws SBonitaReadException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("humanTaskInstanceId", humanTaskInstanceId);
        QueryOptions queryOptions = new QueryOptions(startIndex, maxResults);
        SelectListDescriptor elements = new SelectListDescriptor("getPossibleUserIdsOfPendingTasks", parameters, SActivityInstance.class, queryOptions);
        return this.getPersistenceService().selectList(elements);
    }

    @Override
    public long getNumberOfUsersWhoCanExecutePendingHumanTaskDeploymentInfo(long humanTaskInstanceId, QueryOptions searchOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("humanTaskInstanceId", humanTaskInstanceId);
        return this.getPersistenceService().getNumberOfEntities(SUser.class, WHOCANSTART_PENDING_TASK_SUFFIX, searchOptions, parameters);
    }

    @Override
    public List<SUser> searchUsersWhoCanExecutePendingHumanTaskDeploymentInfo(long humanTaskInstanceId, QueryOptions searchOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("humanTaskInstanceId", humanTaskInstanceId);
        return this.getPersistenceService().searchEntity(SUser.class, WHOCANSTART_PENDING_TASK_SUFFIX, searchOptions, parameters);
    }

    @Override
    public long getNumberOfAssignedAndPendingHumanTasksFor(long rootProcessDefinitionId, long userId, QueryOptions queryOptions) throws SBonitaReadException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("userId", userId);
        parameters.put("rootProcessDefinitionId", rootProcessDefinitionId);
        return this.getPersistenceService().getNumberOfEntities(SHumanTaskInstance.class, ASSIGNED_AND_PENDING_BY_ROOT_PROCESS_FOR, queryOptions, parameters);
    }

    @Override
    public List<SHumanTaskInstance> searchAssignedAndPendingHumanTasksFor(long rootProcessDefinitionId, long userId, QueryOptions queryOptions) throws SBonitaReadException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("userId", userId);
        parameters.put("rootProcessDefinitionId", rootProcessDefinitionId);
        return this.getPersistenceService().searchEntity(SHumanTaskInstance.class, ASSIGNED_AND_PENDING_BY_ROOT_PROCESS_FOR, queryOptions, parameters);
    }

    @Override
    public long getNumberOfAssignedAndPendingHumanTasks(long rootProcessDefinitionId, QueryOptions queryOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("rootProcessDefinitionId", rootProcessDefinitionId);
        return this.getPersistenceService().getNumberOfEntities(SHumanTaskInstance.class, ASSIGNED_AND_PENDING_BY_ROOT_PROCESS, queryOptions, parameters);
    }

    @Override
    public List<SHumanTaskInstance> searchAssignedAndPendingHumanTasks(long rootProcessDefinitionId, QueryOptions queryOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("rootProcessDefinitionId", rootProcessDefinitionId);
        return this.getPersistenceService().searchEntity(SHumanTaskInstance.class, ASSIGNED_AND_PENDING_BY_ROOT_PROCESS, queryOptions, parameters);
    }

    @Override
    public void deleteArchivedFlowNodeInstances(long processInstanceId) throws SFlowNodeDeletionException {
        try {
            this.deleteArchivedFlowNodeInstancesAndElements(processInstanceId);
        }
        catch (SFlowNodeDeletionException e) {
            throw e;
        }
        catch (SBonitaException e) {
            throw new SFlowNodeDeletionException(e);
        }
    }

    private void deleteArchivedFlowNodeInstancesAndElements(long processInstanceId) throws SFlowNodeReadException, SBonitaReadException, SConnectorInstanceDeletionException, SDataInstanceException, SFlowNodeDeletionException {
        List<SAFlowNodeInstance> saFlowNodeInstances;
        Set<Long> sourceActivityIds = new HashSet<Long>();
        do {
            saFlowNodeInstances = this.getArchivedFlowNodeInstances(processInstanceId, 0, 100);
            sourceActivityIds = this.deleteArchivedFlowNodeInstancesAndElements(sourceActivityIds, saFlowNodeInstances);
        } while (!saFlowNodeInstances.isEmpty());
    }

    private Set<Long> deleteArchivedFlowNodeInstancesAndElements(Set<Long> sourceActivityIds, List<SAFlowNodeInstance> saFlowNodeInstances) throws SBonitaReadException, SConnectorInstanceDeletionException, SDataInstanceException, SFlowNodeDeletionException {
        Set<Long> newSourceActivityIds = new HashSet<Long>(sourceActivityIds);
        for (SAFlowNodeInstance saFlowNodeInstance : saFlowNodeInstances) {
            newSourceActivityIds = this.deleteArchivedFlowNodeInstanceAndElements(newSourceActivityIds, saFlowNodeInstance);
        }
        return newSourceActivityIds;
    }

    private Set<Long> deleteArchivedFlowNodeInstanceAndElements(Set<Long> sourceActivityIds, SAFlowNodeInstance saFlowNodeInstance) throws SBonitaReadException, SConnectorInstanceDeletionException, SDataInstanceException, SFlowNodeDeletionException {
        HashSet<Long> newSourceActivityIds = new HashSet<Long>(sourceActivityIds);
        if (saFlowNodeInstance instanceof SAActivityInstance && !sourceActivityIds.contains(saFlowNodeInstance.getSourceObjectId())) {
            newSourceActivityIds.add(saFlowNodeInstance.getSourceObjectId());
            this.deleteArchivedFlowNodeInstanceElements((SAActivityInstance)saFlowNodeInstance);
        }
        this.deleteArchivedFlowNodeInstance(saFlowNodeInstance);
        return newSourceActivityIds;
    }

    private void deleteArchivedFlowNodeInstanceElements(SAActivityInstance saActivityInstance) throws SBonitaReadException, SConnectorInstanceDeletionException, SDataInstanceException {
        this.dataInstanceService.deleteLocalArchivedDataInstances(saActivityInstance.getSourceObjectId(), DataInstanceContainer.ACTIVITY_INSTANCE.toString());
        this.connectorInstanceService.deleteArchivedConnectorInstances(saActivityInstance.getSourceObjectId(), "flowNode");
        if (SFlowNodeType.USER_TASK.equals((Object)saActivityInstance.getType()) || SFlowNodeType.MANUAL_TASK.equals((Object)saActivityInstance.getType())) {
            this.deleteArchivedPendingMappings(saActivityInstance.getSourceObjectId());
        }
    }
}

