/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.state;

import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityStateExecutionException;
import org.bonitasoft.engine.core.process.instance.api.states.FlowNodeState;
import org.bonitasoft.engine.core.process.instance.api.states.StateCode;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.execution.StateBehaviors;

public abstract class EndingFlowNodeContainerExceptionStateImpl
implements FlowNodeState {
    private final StateBehaviors stateBehaviors;

    public EndingFlowNodeContainerExceptionStateImpl(StateBehaviors stateBehaviors) {
        this.stateBehaviors = stateBehaviors;
    }

    @Override
    public boolean shouldExecuteState(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityExecutionException {
        if (flowNodeInstance.getTokenCount() > 0) {
            try {
                this.stateBehaviors.interruptSubActivities(flowNodeInstance.getId(), this.getStateCategory());
            }
            catch (SBonitaException e) {
                throw new SActivityExecutionException(e);
            }
        }
        return flowNodeInstance.getTokenCount() > 0;
    }

    @Override
    public StateCode execute(SProcessDefinition processDefinition, SFlowNodeInstance instance) throws SActivityStateExecutionException {
        return StateCode.DONE;
    }

    @Override
    public boolean hit(SProcessDefinition processDefinition, SFlowNodeInstance parentInstance, SFlowNodeInstance childInstance) {
        return parentInstance.getTokenCount() == 0;
    }

    @Override
    public boolean isInterrupting() {
        return false;
    }

    @Override
    public boolean isStable() {
        return true;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    public StateBehaviors getStateBehaviors() {
        return this.stateBehaviors;
    }
}

