/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.state;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.process.definition.model.SActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SMultiInstanceLoopCharacteristics;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityStateExecutionException;
import org.bonitasoft.engine.core.process.instance.api.states.FlowNodeState;
import org.bonitasoft.engine.core.process.instance.api.states.StateCode;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SMultiInstanceActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.builder.SUserTaskInstanceBuilderFactory;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.execution.ContainerRegistry;
import org.bonitasoft.engine.execution.StateBehaviors;
import org.bonitasoft.engine.expression.ExpressionConstants;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;

public class ExecutingMultiInstanceActivityStateImpl
implements FlowNodeState {
    private final ExpressionResolverService expressionResolverService;
    private final ContainerRegistry containerRegistry;
    private final ActivityInstanceService activityInstanceService;
    private final StateBehaviors stateBehaviors;

    public ExecutingMultiInstanceActivityStateImpl(ExpressionResolverService expressionResolverService, ContainerRegistry containerRegistry, ActivityInstanceService activityInstanceService, StateBehaviors stateBehaviors) {
        this.expressionResolverService = expressionResolverService;
        this.containerRegistry = containerRegistry;
        this.activityInstanceService = activityInstanceService;
        this.stateBehaviors = stateBehaviors;
    }

    @Override
    public int getId() {
        return 28;
    }

    @Override
    public boolean isInterrupting() {
        return false;
    }

    @Override
    public boolean isStable() {
        return true;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public String getName() {
        return "executing";
    }

    @Override
    public boolean hit(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance, SFlowNodeInstance childInstance) throws SActivityStateExecutionException {
        SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
        SActivityDefinition activityDefinition = (SActivityDefinition)processContainer.getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
        SMultiInstanceLoopCharacteristics loopCharacteristics = (SMultiInstanceLoopCharacteristics)activityDefinition.getLoopCharacteristics();
        try {
            SMultiInstanceActivityInstance miActivity = (SMultiInstanceActivityInstance)flowNodeInstance;
            if (miActivity.getStateCategory() != SStateCategory.NORMAL) {
                return true;
            }
            if (childInstance.isAborting() || childInstance.isCanceling()) {
                this.activityInstanceService.addMultiInstanceNumberOfTerminatedActivities(miActivity, 1);
            } else {
                boolean complete;
                this.activityInstanceService.addMultiInstanceNumberOfCompletedActivities(miActivity, 1);
                SExpression completionCondition = loopCharacteristics.getCompletionCondition();
                HashMap<String, Serializable> input = new HashMap<String, Serializable>(1);
                input.put(ExpressionConstants.NUMBER_OF_ACTIVE_INSTANCES.getEngineConstantName(), Integer.valueOf(miActivity.getNumberOfActiveInstances()));
                input.put(ExpressionConstants.NUMBER_OF_TERMINATED_INSTANCES.getEngineConstantName(), Integer.valueOf(miActivity.getNumberOfTerminatedInstances()));
                input.put(ExpressionConstants.NUMBER_OF_COMPLETED_INSTANCES.getEngineConstantName(), Integer.valueOf(miActivity.getNumberOfCompletedInstances()));
                int numberOfInstances = miActivity.getNumberOfInstances();
                input.put(ExpressionConstants.NUMBER_OF_INSTANCES.getEngineConstantName(), Integer.valueOf(numberOfInstances));
                SExpressionContext sExpressionContext = new SExpressionContext((Long)miActivity.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), (Map<String, Serializable>)input);
                if (completionCondition != null && (complete = ((Boolean)this.expressionResolverService.evaluate(completionCondition, sExpressionContext)).booleanValue())) {
                    this.abortNonCompletedChildren(miActivity);
                    if (miActivity.isSequential()) {
                        return true;
                    }
                }
            }
            int numberOfActiveInstances = miActivity.getNumberOfActiveInstances();
            int numberOfCompletedInstances = miActivity.getNumberOfCompletedInstances();
            int numberOfTerminatedInstances = miActivity.getNumberOfTerminatedInstances();
            int numberOfInstances = miActivity.getNumberOfInstances();
            if (miActivity.isSequential()) {
                List<SFlowNodeInstance> createInnerInstances = null;
                if (this.stateBehaviors.shouldCreateANewInstance(loopCharacteristics, numberOfInstances, miActivity)) {
                    createInnerInstances = this.stateBehaviors.createInnerInstances(processDefinition.getId(), activityDefinition, miActivity, 1);
                    for (SFlowNodeInstance sFlowNodeInstance : createInnerInstances) {
                        this.containerRegistry.executeFlowNode(processDefinition.getId(), sFlowNodeInstance.getLogicalGroup(3), sFlowNodeInstance.getId(), null, null);
                    }
                }
                return numberOfActiveInstances == 0 && (createInnerInstances == null || createInnerInstances.size() == 0);
            }
            return numberOfActiveInstances == 0 || numberOfInstances == numberOfCompletedInstances + numberOfTerminatedInstances;
        }
        catch (SBonitaException e) {
            throw new SActivityStateExecutionException(e);
        }
    }

    private boolean abortNonCompletedChildren(SFlowNodeInstance flowNodeInstance) throws SBonitaException {
        List<SActivityInstance> children;
        int numberOfResults = 100;
        long count = 0L;
        boolean hasChildren = false;
        SUserTaskInstanceBuilderFactory keyProvider = BuilderFactory.get(SUserTaskInstanceBuilderFactory.class);
        do {
            OrderByOption orderByOption = new OrderByOption(SActivityInstance.class, keyProvider.getNameKey(), OrderByType.ASC);
            ArrayList<FilterOption> filters = new ArrayList<FilterOption>(2);
            filters.add(new FilterOption(SActivityInstance.class, keyProvider.getParentActivityInstanceKey(), flowNodeInstance.getId()));
            filters.add(new FilterOption(SActivityInstance.class, keyProvider.getTerminalKey(), false));
            filters.add(new FilterOption(SActivityInstance.class, keyProvider.getStateCategoryKey(), SStateCategory.NORMAL.name()));
            QueryOptions queryOptions = new QueryOptions(0, 100, Collections.singletonList(orderByOption), filters, null);
            QueryOptions countOptions = new QueryOptions(0, 100, null, filters, null);
            children = this.activityInstanceService.searchActivityInstances(SActivityInstance.class, queryOptions);
            count = this.activityInstanceService.getNumberOfActivityInstances(SActivityInstance.class, countOptions);
            if (count > 0L) {
                hasChildren = true;
            }
            for (SActivityInstance child : children) {
                this.activityInstanceService.setStateCategory(child, SStateCategory.ABORTING);
                if (!child.isStable()) continue;
                this.containerRegistry.executeFlowNode(flowNodeInstance.getProcessDefinitionId(), child.getLogicalGroup(3), child.getId(), null, null);
            }
        } while (count > (long)children.size());
        return hasChildren;
    }

    @Override
    public boolean shouldExecuteState(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityExecutionException {
        int numberOfActiveInstances = ((SMultiInstanceActivityInstance)flowNodeInstance).getNumberOfActiveInstances();
        if (numberOfActiveInstances > 0) {
            this.stateBehaviors.executeChildrenActivities(flowNodeInstance);
        }
        return numberOfActiveInstances > 0;
    }

    @Override
    public final StateCode execute(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) {
        return StateCode.DONE;
    }

    @Override
    public SStateCategory getStateCategory() {
        return SStateCategory.NORMAL;
    }

    @Override
    public boolean mustAddSystemComment(SFlowNodeInstance flowNodeInstance) {
        return false;
    }

    @Override
    public String getSystemComment(SFlowNodeInstance flowNodeInstance) {
        return "";
    }
}

