/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.state;

import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityStateExecutionException;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SHumanTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.execution.StateBehaviors;
import org.bonitasoft.engine.execution.state.FlowNodeStateWithConnectors;

public class ReadyActivityStateImpl
extends FlowNodeStateWithConnectors {
    private final StateBehaviors stateBehaviors;

    public ReadyActivityStateImpl(StateBehaviors stateBehaviors) {
        super(stateBehaviors, false, true);
        this.stateBehaviors = stateBehaviors;
    }

    @Override
    protected void beforeOnEnter(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        if (((SHumanTaskInstance)flowNodeInstance).getAssigneeId() <= 0L) {
            throw new SActivityStateExecutionException("The activity is not yet assigned, unable to execute it");
        }
    }

    @Override
    protected void onEnterToOnFinish(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        this.stateBehaviors.executeOperations(processDefinition, (SActivityInstance)flowNodeInstance);
    }

    @Override
    protected void afterOnFinish(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        this.stateBehaviors.mapDataOutputOfMultiInstance(processDefinition, flowNodeInstance);
        this.stateBehaviors.updateDisplayDescriptionAfterCompletion(processDefinition, flowNodeInstance);
    }

    @Override
    public int getId() {
        return 4;
    }

    @Override
    public boolean isInterrupting() {
        return false;
    }

    @Override
    public boolean isStable() {
        return true;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public String getName() {
        return "ready";
    }

    @Override
    public boolean hit(SProcessDefinition processDefinition, SFlowNodeInstance parentInstance, SFlowNodeInstance childInstance) {
        return false;
    }

    @Override
    public boolean shouldExecuteState(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) {
        return true;
    }

    @Override
    public SStateCategory getStateCategory() {
        return SStateCategory.NORMAL;
    }

    @Override
    public boolean mustAddSystemComment(SFlowNodeInstance flowNodeInstance) {
        return false;
    }

    @Override
    public String getSystemComment(SFlowNodeInstance flowNodeInstance) {
        return "";
    }
}

