/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.expression.ContainerState;
import org.bonitasoft.engine.expression.NonEmptyContentExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.ExpressionKind;
import org.bonitasoft.engine.expression.model.SExpression;

public class ConditionExpressionExecutorStrategy
extends NonEmptyContentExpressionExecutorStrategy {
    private static final String LOGICAL_COMPLEMENT_OPERATOR = "!";
    private static final String NOT_EQUALS_COMPARATOR = "!=";
    private static final String EQUALS_COMPARATOR = "==";
    private static final String GREATER_THAN_OR_EQUALS_COMPARATOR = ">=";
    private static final String lESS_THAN_OR_EQUALS_COMPARATOR = "<=";
    private static final String GREATER_THAN_COMPARATOR = ">";
    private static final String LESS_THAN_COMPARATOR = "<";
    private final List<String> validOperators = new ArrayList<String>(7);
    private final Set<String> numericTypes;

    public ConditionExpressionExecutorStrategy() {
        this.validOperators.add(LESS_THAN_COMPARATOR);
        this.validOperators.add(GREATER_THAN_COMPARATOR);
        this.validOperators.add(lESS_THAN_OR_EQUALS_COMPARATOR);
        this.validOperators.add(GREATER_THAN_OR_EQUALS_COMPARATOR);
        this.validOperators.add(EQUALS_COMPARATOR);
        this.validOperators.add(NOT_EQUALS_COMPARATOR);
        this.validOperators.add(LOGICAL_COMPLEMENT_OPERATOR);
        this.numericTypes = new HashSet<String>();
        this.numericTypes.add(Integer.class.getName());
        this.numericTypes.add(Long.class.getName());
        this.numericTypes.add(Double.class.getName());
        this.numericTypes.add(Float.class.getName());
        this.numericTypes.add(Short.class.getName());
        this.numericTypes.add(Byte.class.getName());
        this.numericTypes.add(Integer.TYPE.getName());
        this.numericTypes.add(Long.TYPE.getName());
        this.numericTypes.add(Double.TYPE.getName());
        this.numericTypes.add(Float.TYPE.getName());
        this.numericTypes.add(Short.TYPE.getName());
        this.numericTypes.add(Byte.TYPE.getName());
    }

    @Override
    public Object evaluate(SExpression expression, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionEvaluationException {
        List<SExpression> dependencies = expression.getDependencies();
        String content = expression.getContent();
        Object result = !LOGICAL_COMPLEMENT_OPERATOR.equals(content) ? this.evaluateBinaryComparator(resolvedExpressions, dependencies, content) : this.evaluateBooleanOperator(resolvedExpressions, dependencies, content);
        return result;
    }

    private Object evaluateBooleanOperator(Map<Integer, Object> resolvedExpressions, List<SExpression> dependencies, String content) throws SExpressionEvaluationException {
        String expressionName = dependencies.get(0).getName();
        this.throwSExpressionEvaluationExceptionIfBadDependenciesSize(dependencies, 1, content, expressionName);
        if (!Boolean.class.getName().equals(dependencies.get(0).getReturnType())) {
            throw new SExpressionEvaluationException("The dependency of expression '" + content + "' must have the return type " + Boolean.class.getName(), expressionName);
        }
        return (Boolean)resolvedExpressions.get(dependencies.get(0).getDiscriminant()) == false;
    }

    private Object evaluateBinaryComparator(Map<Integer, Object> resolvedExpressions, List<SExpression> dependencies, String content) throws SExpressionEvaluationException {
        String expressionName = dependencies.get(0).getName();
        this.throwSExpressionEvaluationExceptionIfBadDependenciesSize(dependencies, 2, content, expressionName);
        if (!this.returnTypeCompatible(dependencies) && !EQUALS_COMPARATOR.equals(content)) {
            throw new SExpressionEvaluationException("The two dependencies of expression '" + content + "' must have the same return type.", expressionName);
        }
        Object resolvedLeftExpr = this.transtypeIfApplicable(dependencies.get(0).getReturnType(), resolvedExpressions.get(dependencies.get(0).getDiscriminant()));
        Object resolvedRightExpr = this.transtypeIfApplicable(dependencies.get(1).getReturnType(), resolvedExpressions.get(dependencies.get(1).getDiscriminant()));
        Boolean result = null;
        if (EQUALS_COMPARATOR.equals(content)) {
            result = this.areEquals(resolvedLeftExpr, resolvedRightExpr);
        } else if (NOT_EQUALS_COMPARATOR.equals(content)) {
            result = this.areEquals(resolvedLeftExpr, resolvedRightExpr) == false;
        } else if (resolvedLeftExpr instanceof Comparable && resolvedRightExpr instanceof Comparable) {
            Integer compare = this.compareTo((Comparable)resolvedLeftExpr, (Comparable)resolvedRightExpr);
            if (GREATER_THAN_COMPARATOR.equals(content)) {
                result = compare > 0;
            } else if (GREATER_THAN_OR_EQUALS_COMPARATOR.equals(content)) {
                result = compare >= 0;
            } else if (LESS_THAN_COMPARATOR.equals(content)) {
                result = compare < 0;
            } else if (lESS_THAN_OR_EQUALS_COMPARATOR.equals(content)) {
                result = compare <= 0;
            }
        } else {
            throw new SExpressionEvaluationException("The two dependencies of expression '" + content + "' must implements java.lang.Comparable.", expressionName);
        }
        return result;
    }

    private boolean returnTypeCompatible(List<SExpression> dependencies) {
        String r1 = dependencies.get(0).getReturnType();
        String r2 = dependencies.get(1).getReturnType();
        return this.numericTypes.contains(r1) && this.numericTypes.contains(r2) || r1.equals(r2);
    }

    private Object transtypeIfApplicable(String type, Object object) {
        if (object == null) {
            return null;
        }
        if (this.numericTypes.contains(type)) {
            return new BigDecimal(String.valueOf(object));
        }
        return object;
    }

    private <T> Boolean areEquals(T left, T right) {
        if (left == null) {
            return right == null;
        }
        return left.equals(right);
    }

    private <T extends Comparable<Object>, R extends Comparable<Object>> Integer compareTo(T left, R right) {
        int result = 0;
        if (left != right) {
            result = left == null || right == null ? (left == null ? -1 : 1) : left.compareTo(right);
        }
        return result;
    }

    private void throwSExpressionEvaluationExceptionIfBadDependenciesSize(List<SExpression> dependencies, int nbDependencies, String content, String expressionName) throws SExpressionEvaluationException {
        if (dependencies.size() != nbDependencies) {
            throw new SExpressionEvaluationException("The expression '" + content + "' must have exactly " + nbDependencies + " dependencies.", expressionName);
        }
    }

    @Override
    public void validate(SExpression expression) throws SInvalidExpressionException {
        super.validate(expression);
        if (!this.validOperators.contains(expression.getContent())) {
            throw new SInvalidExpressionException("The content of expression must be among: " + this.validOperators + " for expression: " + expression.toString(), expression.getName());
        }
    }

    @Override
    public ExpressionKind getExpressionKind() {
        return new ExpressionKind("TYPE_CONDITION");
    }

    @Override
    public List<Object> evaluate(List<SExpression> expressions, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionEvaluationException {
        ArrayList<Object> evaluatedExpressions = new ArrayList<Object>(expressions.size());
        for (SExpression sExpression : expressions) {
            evaluatedExpressions.add(this.evaluate(sExpression, context, resolvedExpressions, containerState));
        }
        return evaluatedExpressions;
    }

    @Override
    public boolean mustPutEvaluatedExpressionInContext() {
        return false;
    }
}

