/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.bonitasoft.engine.expression.ContainerState;
import org.bonitasoft.engine.expression.NonEmptyContentExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.model.ExpressionKind;
import org.bonitasoft.engine.expression.model.SExpression;

public class PatternExpressionExecutorStrategy
extends NonEmptyContentExpressionExecutorStrategy {
    @Override
    public Serializable evaluate(SExpression expression, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionDependencyMissingException {
        List<SExpression> dependencies = expression.getDependencies();
        HashMap<String, Object> values = new HashMap<String, Object>(dependencies.size());
        for (SExpression exp : dependencies) {
            String name = exp.getName();
            Object value = resolvedExpressions.get(exp.getDiscriminant());
            if (value == null) {
                throw new SExpressionDependencyMissingException("Expression dependency not found: " + name);
            }
            values.put(name, value);
        }
        StrSubstitutor strSubstitutor = new StrSubstitutor(values);
        return strSubstitutor.replace(expression.getContent());
    }

    @Override
    public ExpressionKind getExpressionKind() {
        return KIND_PATTERN;
    }

    @Override
    public List<Object> evaluate(List<SExpression> expressions, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionDependencyMissingException {
        ArrayList<Object> list = new ArrayList<Object>(expressions.size());
        for (SExpression expression : expressions) {
            list.add(this.evaluate(expression, (Map)context, (Map)resolvedExpressions, containerState));
        }
        return list;
    }

    @Override
    public boolean mustPutEvaluatedExpressionInContext() {
        return false;
    }
}

