/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression.model.impl;

import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.expression.model.ExpressionKind;
import org.bonitasoft.engine.expression.model.SExpression;

public class SExpressionImpl
implements SExpression {
    private static final long serialVersionUID = 1L;
    private String name;
    private String content;
    private String returnType;
    private List<SExpression> dependencies;
    private final ExpressionKind expressionKind = new ExpressionKind();

    public SExpressionImpl() {
    }

    public SExpressionImpl(String name, String content, String expressionType, String returnType, String interpreter, List<SExpression> dependencies) {
        this.name = name;
        this.content = content;
        this.expressionKind.setType(expressionType);
        this.returnType = returnType;
        this.expressionKind.setInterpreter(interpreter);
        this.dependencies = dependencies;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setExpressionType(String expressionType) {
        this.expressionKind.setType(expressionType);
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public void setInterpreter(String interpreter) {
        this.expressionKind.setInterpreter(interpreter);
    }

    public void setDependencies(List<SExpression> dependencies) {
        this.dependencies = dependencies;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public String getExpressionType() {
        return this.expressionKind.getExpressionType();
    }

    @Override
    public String getReturnType() {
        return this.returnType;
    }

    @Override
    public String getInterpreter() {
        return this.expressionKind.getInterpreter();
    }

    @Override
    public List<SExpression> getDependencies() {
        if (this.dependencies == null) {
            return Collections.emptyList();
        }
        return this.dependencies;
    }

    @Override
    public ExpressionKind getExpressionKind() {
        return this.expressionKind;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        result = 31 * result + (this.dependencies == null ? 0 : this.dependencies.hashCode());
        result = 31 * result + (this.expressionKind == null ? 0 : this.expressionKind.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SExpressionImpl other = (SExpressionImpl)obj;
        if (this.content == null ? other.content != null : !this.content.equals(other.content)) {
            return false;
        }
        if (this.dependencies == null ? other.dependencies != null : !this.dependencies.equals(other.dependencies)) {
            return false;
        }
        if (this.expressionKind == null ? other.expressionKind != null : !this.expressionKind.equals(other.expressionKind)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType));
    }

    public String toString() {
        int maxLen = 5;
        StringBuilder builder = new StringBuilder();
        builder.append("SExpressionImpl [name=");
        builder.append(this.name);
        builder.append(", content=");
        builder.append(this.content);
        builder.append(", returnType=");
        builder.append(this.returnType);
        builder.append(", dependencies=");
        builder.append(this.dependencies != null ? this.dependencies.subList(0, Math.min(this.dependencies.size(), 5)) : null);
        builder.append(", expressionKind=");
        builder.append(this.expressionKind);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int getDiscriminant() {
        return this.hashCode();
    }
}

