/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.web.forms;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.impl.SessionInfos;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.OperationService;
import org.bonitasoft.engine.core.operation.exception.SOperationExecutionException;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.comment.api.SCommentService;
import org.bonitasoft.engine.core.process.definition.model.builder.ServerModelConvertor;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeReadException;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.execution.ProcessExecutor;
import org.bonitasoft.engine.external.web.forms.ExecuteActionsBaseEntry;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.log.LogMessageBuilder;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceSingleton;

public class ExecuteActionsAndTerminateTask
extends ExecuteActionsBaseEntry {
    public static final String ACTIVITY_INSTANCE_ID_KEY = "ACTIVITY_INSTANCE_ID_KEY";
    public static final String USER_ID_KEY = "USER_ID_KEY";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable execute(Map<String, Serializable> parameters, TenantServiceAccessor tenantAccessor) throws SCommandParameterizationException, SCommandExecutionException {
        List<Operation> operations = this.getOperations(parameters);
        Map<String, Serializable> operationsContext = this.getOperationsContext(parameters);
        long sActivityInstanceID = this.getActivityInstanceId(parameters);
        try {
            ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
            ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
            SFlowNodeInstance flowNodeInstance = activityInstanceService.getFlowNodeInstance(sActivityInstanceID);
            long processDefinitionID = flowNodeInstance.getProcessDefinitionId();
            ClassLoader processClassloader = classLoaderService.getLocalClassLoader(ScopeType.PROCESS.name(), processDefinitionID);
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(processClassloader);
                this.updateActivityInstanceVariables(operations, operationsContext, sActivityInstanceID, processDefinitionID);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
            long executedByUserId = this.getExecuteByUserId(parameters);
            this.executeActivity(flowNodeInstance, executedByUserId);
        }
        catch (SBonitaException e) {
            this.log(tenantAccessor, e);
            throw new SCommandExecutionException("Error executing command 'Map<String, Serializable> ExecuteActionsAndTerminateTask(List<Operation>, Map<String, Serializable>, long activityInstanceId)'", e);
        }
        return null;
    }

    protected Long getExecuteByUserId(Map<String, Serializable> parameters) {
        Serializable executeByUserId = parameters.get(USER_ID_KEY);
        if (executeByUserId == null) {
            return SessionInfos.getSessionInfos().getUserId();
        }
        return (Long)executeByUserId;
    }

    protected Long getActivityInstanceId(Map<String, Serializable> parameters) throws SCommandParameterizationException {
        String message = "Mandatory parameter ACTIVITY_INSTANCE_ID_KEY is missing or not convertible to long.";
        return (Long)this.getMandatoryParameter(parameters, ACTIVITY_INSTANCE_ID_KEY, "Mandatory parameter ACTIVITY_INSTANCE_ID_KEY is missing or not convertible to long.");
    }

    protected List<Operation> getOperations(Map<String, Serializable> parameters) throws SCommandParameterizationException {
        String message = "Mandatory parameter OPERATIONS_LIST_KEY is missing or not convertible to List.";
        List operations = (List)this.getParameter(parameters, "OPERATIONS_LIST_KEY", "Mandatory parameter OPERATIONS_LIST_KEY is missing or not convertible to List.");
        if (operations == null) {
            return Collections.emptyList();
        }
        return operations;
    }

    protected Map<String, Serializable> getOperationsContext(Map<String, Serializable> parameters) throws SCommandParameterizationException {
        String message = "Mandatory parameter OPERATIONS_INPUT_KEY is missing or not convertible to Map.";
        Map operations = (Map)this.getParameter(parameters, "OPERATIONS_INPUT_KEY", "Mandatory parameter OPERATIONS_INPUT_KEY is missing or not convertible to Map.");
        if (operations == null) {
            return Collections.emptyMap();
        }
        return operations;
    }

    protected void updateActivityInstanceVariables(List<Operation> operations, Map<String, Serializable> operationsContext, long activityInstanceId, Long processDefinitionID) throws SOperationExecutionException {
        SExpressionContext sExpressionContext = this.buildExpressionContext(operationsContext, activityInstanceId, processDefinitionID);
        List<SOperation> sOperations = ServerModelConvertor.convertOperations(operations);
        this.getOperationService().execute(sOperations, activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.name(), sExpressionContext);
    }

    private SExpressionContext buildExpressionContext(Map<String, Serializable> operationsContext, long activityInstanceId, Long processDefinitionID) {
        SExpressionContext sExpressionContext = new SExpressionContext();
        sExpressionContext.setSerializableInputValues(operationsContext);
        sExpressionContext.setContainerId(activityInstanceId);
        sExpressionContext.setContainerType(DataInstanceContainer.ACTIVITY_INSTANCE.name());
        sExpressionContext.setProcessDefinitionId(processDefinitionID);
        return sExpressionContext;
    }

    private OperationService getOperationService() {
        TenantServiceAccessor tenantAccessor = TenantServiceSingleton.getInstance(this.getTenantId());
        return tenantAccessor.getOperationService();
    }

    protected void executeActivity(SFlowNodeInstance flowNodeInstance, long executerUserId) throws SFlowNodeReadException, SFlowNodeExecutionException {
        TenantServiceAccessor tenantAccessor = TenantServiceSingleton.getInstance(this.getTenantId());
        ProcessExecutor processExecutor = tenantAccessor.getProcessExecutor();
        TechnicalLoggerService logger = tenantAccessor.getTechnicalLoggerService();
        SessionInfos sessionInfos = SessionInfos.getSessionInfos();
        long executerSubstituteId = sessionInfos.getUserId();
        processExecutor.executeFlowNode(flowNodeInstance.getId(), null, null, flowNodeInstance.getProcessDefinitionId(), executerUserId, executerSubstituteId);
        if (logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO) && flowNodeInstance.getStateId() != 0) {
            String message = LogMessageBuilder.buildExecuteTaskContextMessage(flowNodeInstance, sessionInfos.getUsername(), executerUserId, executerSubstituteId);
            logger.log(this.getClass(), TechnicalLogSeverity.INFO, message);
        }
        this.addSystemCommentOnProcessInstanceWhenExecutingTaskFor(flowNodeInstance, executerUserId, executerSubstituteId);
    }

    protected void addSystemCommentOnProcessInstanceWhenExecutingTaskFor(SFlowNodeInstance flowNodeInstance, long executerUserId, long executerSubstituteUserId) {
        TenantServiceAccessor tenantAccessor = ExecuteActionsAndTerminateTask.getTenantAccessor();
        TechnicalLoggerService logger = tenantAccessor.getTechnicalLoggerService();
        SCommentService commentService = tenantAccessor.getCommentService();
        SessionInfos session = SessionInfos.getSessionInfos();
        if (executerUserId != executerSubstituteUserId) {
            IdentityService identityService = tenantAccessor.getIdentityService();
            try {
                SUser executerUser = identityService.getUser(executerUserId);
                StringBuilder stb = new StringBuilder();
                stb.append("The user " + session.getUsername() + " ");
                stb.append("acting as delegate of the user " + executerUser.getUserName() + " ");
                stb.append("has done the task \"" + flowNodeInstance.getDisplayName() + "\".");
                commentService.addSystemComment(flowNodeInstance.getParentProcessInstanceId(), stb.toString());
            }
            catch (SBonitaException e) {
                logger.log(this.getClass(), TechnicalLogSeverity.ERROR, "Error when adding a comment on the process instance.", e);
            }
        }
    }
}

