/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.jobs;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.model.event.trigger.STimerEventTriggerInstance;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.scheduler.AbstractBonitaTenantJobListener;
import org.bonitasoft.engine.scheduler.StatelessJob;

public class TimerEventTriggerJobListener
extends AbstractBonitaTenantJobListener {
    private static final long serialVersionUID = -5060516371371295271L;
    private static final String LISTENER_NAME = "TimerEventTriggerJobListener_";
    private final EventInstanceService eventInstanceService;
    private final TechnicalLoggerService logger;

    public TimerEventTriggerJobListener(EventInstanceService eventInstanceService, long tenantId, TechnicalLoggerService logger) {
        super(tenantId);
        this.eventInstanceService = eventInstanceService;
        this.logger = logger;
    }

    @Override
    public String getName() {
        return LISTENER_NAME + this.getTenantId();
    }

    @Override
    public void jobToBeExecuted(Map<String, Serializable> context) {
    }

    @Override
    public void jobExecutionVetoed(Map<String, Serializable> context) {
    }

    @Override
    public void jobWasExecuted(Map<String, Serializable> context, Exception jobException) {
        block3: {
            StatelessJob bosJob = (StatelessJob)context.get("bosJob");
            if (bosJob == null) {
                return;
            }
            String triggerName = (String)((Object)context.get("triggerName"));
            try {
                this.deleteTimerEventTrigger(triggerName);
            }
            catch (SBonitaException e) {
                if (!this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) break block3;
                this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, "An exception occurs during the deleting of the timer event trigger '" + triggerName + "'.", e);
            }
        }
    }

    void deleteTimerEventTrigger(String triggerName) throws SBonitaException {
        List<FilterOption> filters = Collections.singletonList(new FilterOption(STimerEventTriggerInstance.class, "jobTriggerName", triggerName));
        List<OrderByOption> orders = Arrays.asList(new OrderByOption(STimerEventTriggerInstance.class, "id", OrderByType.ASC));
        QueryOptions queryOptions = new QueryOptions(0, 1, orders, filters, null);
        List<STimerEventTriggerInstance> timerEventTriggerInstances = this.eventInstanceService.searchEventTriggerInstances(STimerEventTriggerInstance.class, queryOptions);
        if (!timerEventTriggerInstances.isEmpty()) {
            this.eventInstanceService.deleteEventTriggerInstance(timerEventTriggerInstances.get(0));
        }
    }
}

