/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.persistence;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.persistence.SQLTransformer;

public class DBConfiguration {
    private final String createTablesFile;
    private final String initTablesFile;
    private final String cleanTablesFile;
    private final String dropTablesFile;
    private final List<String> filter;
    private final String deleteTenantObjectsFile;
    private final String postCreateStructureFile;
    private final String preDropStructureFile;
    private Map<String, SQLTransformer> sqlTransformers;
    private int deleteTenantObjectsPriority;

    public DBConfiguration(String createTablesFile, String dropTablesFile, String initTablesFile, String cleanTablesFile, String filter) {
        this.createTablesFile = createTablesFile;
        this.dropTablesFile = dropTablesFile;
        this.initTablesFile = initTablesFile;
        this.cleanTablesFile = cleanTablesFile;
        this.filter = Arrays.asList(filter);
        this.deleteTenantObjectsFile = null;
        this.postCreateStructureFile = null;
        this.preDropStructureFile = null;
    }

    public DBConfiguration(String createTablesFile, String dropTablesFile, String initTablesFile, String cleanTablesFile, String filter, String postCreateStructureFile, String preDropStructureFile) {
        this.createTablesFile = createTablesFile;
        this.dropTablesFile = dropTablesFile;
        this.initTablesFile = initTablesFile;
        this.cleanTablesFile = cleanTablesFile;
        this.filter = Arrays.asList(filter);
        this.deleteTenantObjectsFile = null;
        this.postCreateStructureFile = postCreateStructureFile;
        this.preDropStructureFile = preDropStructureFile;
    }

    public DBConfiguration(String createTablesFile, String dropTablesFile, String initTablesFile, String cleanTablesFile, String filter, String deleteTenantObjectsFile, int deleteTenantObjectsPriority, String postCreateStructureFile, String preDropStructureFile) {
        this.createTablesFile = createTablesFile;
        this.dropTablesFile = dropTablesFile;
        this.initTablesFile = initTablesFile;
        this.cleanTablesFile = cleanTablesFile;
        this.filter = Arrays.asList(filter);
        this.deleteTenantObjectsFile = deleteTenantObjectsFile;
        this.postCreateStructureFile = postCreateStructureFile;
        this.preDropStructureFile = preDropStructureFile;
        this.deleteTenantObjectsPriority = deleteTenantObjectsPriority;
    }

    public DBConfiguration(String createTablesFile, String dropTablesFile, String initTablesFile, String cleanTablesFile, String filter, String deleteTenantObjectsFile, int deleteTenantObjectsPriority) {
        this.createTablesFile = createTablesFile;
        this.dropTablesFile = dropTablesFile;
        this.initTablesFile = initTablesFile;
        this.cleanTablesFile = cleanTablesFile;
        this.filter = Arrays.asList(filter);
        this.deleteTenantObjectsFile = deleteTenantObjectsFile;
        this.postCreateStructureFile = null;
        this.preDropStructureFile = null;
        this.deleteTenantObjectsPriority = deleteTenantObjectsPriority;
    }

    public DBConfiguration(String postCreateStructureFile, String preDropStructureFile, String filter) {
        this.createTablesFile = null;
        this.dropTablesFile = null;
        this.initTablesFile = null;
        this.cleanTablesFile = null;
        this.filter = Arrays.asList(filter);
        this.deleteTenantObjectsFile = null;
        this.postCreateStructureFile = postCreateStructureFile;
        this.preDropStructureFile = preDropStructureFile;
    }

    public String getCreateTablesFile() {
        return this.createTablesFile;
    }

    public String getDropTablesFile() {
        return this.dropTablesFile;
    }

    public String getInitTablesFile() {
        return this.initTablesFile;
    }

    public String getCleanTablesFile() {
        return this.cleanTablesFile;
    }

    public String getDeleteTenantObjectsFile() {
        return this.deleteTenantObjectsFile;
    }

    public int getDeleteTenantObjectsPriority() {
        return this.deleteTenantObjectsPriority;
    }

    public void setDeleteTenantObjectsPriority(int deleteTenantObjectsPriority) {
        this.deleteTenantObjectsPriority = deleteTenantObjectsPriority;
    }

    protected List<String> getFilter() {
        return this.filter;
    }

    public boolean hasCreateTablesFile() {
        return this.createTablesFile != null && !this.createTablesFile.isEmpty();
    }

    public boolean hasDropTablesFile() {
        return this.dropTablesFile != null && !this.dropTablesFile.isEmpty();
    }

    public boolean hasInitTablesFile() {
        return this.initTablesFile != null && !this.initTablesFile.isEmpty();
    }

    public boolean hasCleanTablesFile() {
        return this.cleanTablesFile != null && !this.cleanTablesFile.isEmpty();
    }

    public boolean matchesFilter(String persistenceServiceName) {
        return this.filter == null ? persistenceServiceName == null : this.filter.contains(persistenceServiceName);
    }

    public boolean hasDeleteTenantObjectsFile() {
        return this.deleteTenantObjectsFile != null && !this.deleteTenantObjectsFile.isEmpty();
    }

    public String getPostCreateStructureFile() {
        return this.postCreateStructureFile;
    }

    public boolean hasPostCreateStructureFile() {
        return this.postCreateStructureFile != null && !this.postCreateStructureFile.isEmpty();
    }

    public String getPreDropStructureFile() {
        return this.preDropStructureFile;
    }

    public boolean hasPreDropStructureFile() {
        return this.preDropStructureFile != null && !this.preDropStructureFile.isEmpty();
    }

    public Map<String, SQLTransformer> getSqlTransformers() {
        return this.sqlTransformers;
    }

    public void setSqlTransformers(Map<String, SQLTransformer> sqlTransformers) {
        this.sqlTransformers = sqlTransformers;
    }

    public boolean hasSqlTransformers() {
        return this.sqlTransformers != null && !this.sqlTransformers.isEmpty();
    }
}

