/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.persistence;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.SearchFields;

public class QueryOptions
implements Serializable {
    private static final long serialVersionUID = 8923754215920928153L;
    private final int fromIndex;
    private final int numberOfResults;
    private final List<FilterOption> filters;
    private final SearchFields multipleFilter;
    private final List<OrderByOption> orderByOptions;
    public static final int UNLIMITED_NUMBER_OF_RESULTS = Integer.MAX_VALUE;
    private static final QueryOptions ALL_RESULTS_QUERY_OPTIONS = new QueryOptions(0, Integer.MAX_VALUE);

    public QueryOptions(QueryOptions queryOptions) {
        this.fromIndex = queryOptions.getFromIndex();
        this.numberOfResults = queryOptions.getNumberOfResults();
        this.orderByOptions = queryOptions.getOrderByOptions();
        this.filters = queryOptions.getFilters();
        this.multipleFilter = queryOptions.getMultipleFilter();
    }

    public QueryOptions(int fromIndex, int numberOfResults) {
        this.fromIndex = fromIndex;
        this.numberOfResults = numberOfResults;
        this.orderByOptions = Collections.emptyList();
        this.filters = Collections.emptyList();
        this.multipleFilter = null;
    }

    public QueryOptions(int fromIndex, int numberOfResults, List<OrderByOption> orderByOptions) {
        this.fromIndex = fromIndex;
        this.numberOfResults = numberOfResults;
        this.orderByOptions = orderByOptions;
        this.filters = Collections.emptyList();
        this.multipleFilter = null;
    }

    public QueryOptions(int fromIndex, int numberOfResults, List<OrderByOption> orderByOptions, List<FilterOption> filters, SearchFields multipleFilter) {
        this.fromIndex = fromIndex;
        this.numberOfResults = numberOfResults;
        this.orderByOptions = orderByOptions;
        this.filters = filters;
        this.multipleFilter = multipleFilter;
    }

    public QueryOptions(List<FilterOption> filters, SearchFields multipleFilter) {
        this(0, Integer.MAX_VALUE, Collections.emptyList(), filters, multipleFilter);
    }

    public QueryOptions(int fromIndex, int numberOfResults, Class<? extends PersistentObject> clazz, String fieldName, OrderByType orderByType) {
        this.fromIndex = fromIndex;
        this.numberOfResults = numberOfResults;
        if (fieldName == null || orderByType == null) {
            this.orderByOptions = Collections.emptyList();
        } else {
            this.orderByOptions = new ArrayList<OrderByOption>();
            this.orderByOptions.add(new OrderByOption(clazz, fieldName, orderByType));
        }
        this.filters = Collections.emptyList();
        this.multipleFilter = null;
    }

    @Deprecated
    public QueryOptions(List<OrderByOption> orderByOptions) {
        this.fromIndex = 0;
        this.numberOfResults = Integer.MAX_VALUE;
        this.orderByOptions = orderByOptions;
        this.filters = Collections.emptyList();
        this.multipleFilter = null;
    }

    @Deprecated
    public QueryOptions(Class<? extends PersistentObject> clazz, String fieldName, OrderByType orderByType) {
        this.fromIndex = 0;
        this.numberOfResults = Integer.MAX_VALUE;
        this.orderByOptions = new ArrayList<OrderByOption>();
        this.orderByOptions.add(new OrderByOption(clazz, fieldName, orderByType));
        this.filters = Collections.emptyList();
        this.multipleFilter = null;
    }

    public int getFromIndex() {
        return this.fromIndex;
    }

    public int getNumberOfResults() {
        return this.numberOfResults;
    }

    public List<FilterOption> getFilters() {
        return this.filters;
    }

    public SearchFields getMultipleFilter() {
        return this.multipleFilter;
    }

    public List<OrderByOption> getOrderByOptions() {
        return this.orderByOptions;
    }

    public boolean hasOrderByOptions() {
        return this.orderByOptions != null && !this.orderByOptions.isEmpty();
    }

    public static QueryOptions countQueryOptions() {
        return ALL_RESULTS_QUERY_OPTIONS;
    }

    public static QueryOptions getNextPage(QueryOptions queryOptions) {
        return new QueryOptions(queryOptions.getFromIndex() + queryOptions.getNumberOfResults(), queryOptions.getNumberOfResults(), queryOptions.getOrderByOptions());
    }

    public String toString() {
        return "QueryOptions [fromIndex=" + this.fromIndex + ", numberOfResults=" + this.numberOfResults + ", orderByOptions=" + this.orderByOptions + "]";
    }

    public boolean hasAFilter() {
        return this.filters != null && !this.filters.isEmpty() || this.multipleFilter != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryOptions)) {
            return false;
        }
        QueryOptions that = (QueryOptions)o;
        if (this.fromIndex != that.fromIndex) {
            return false;
        }
        if (this.numberOfResults != that.numberOfResults) {
            return false;
        }
        if (this.filters != null ? !this.filters.equals(that.filters) : that.filters != null) {
            return false;
        }
        if (this.multipleFilter != null ? !this.multipleFilter.equals(that.multipleFilter) : that.multipleFilter != null) {
            return false;
        }
        return !(this.orderByOptions != null ? !this.orderByOptions.equals(that.orderByOptions) : that.orderByOptions != null);
    }

    public int hashCode() {
        int result = this.fromIndex;
        result = 31 * result + this.numberOfResults;
        result = 31 * result + (this.filters != null ? this.filters.hashCode() : 0);
        result = 31 * result + (this.multipleFilter != null ? this.multipleFilter.hashCode() : 0);
        result = 31 * result + (this.orderByOptions != null ? this.orderByOptions.hashCode() : 0);
        return result;
    }
}

