/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.scheduler.impl;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.scheduler.AbstractBonitaPlatformJobListener;

public class TechnicalLoggerJobListener
extends AbstractBonitaPlatformJobListener {
    private static final long serialVersionUID = 2830540082890033377L;
    private static final String jobToBeFiredMessage = "Job FIRED : group=''{1}'', name=''{0}'', class=''{5}'', data=''{6}'', triggerGroup=''{4}'', triggerName=''{3}'', at=''{2, date,HH:mm:ss MM/dd/yyyy}''";
    private static final String jobSuccessMessage = "Job COMPLETED : group=''{1}'', name=''{0}'', class=''{4}'', data=''{5}'', at=''{2, date,HH:mm:ss MM/dd/yyyy}'', reports=''{3}''";
    private static final String jobFailedMessage = "Job FAILED : group=''{1}'', name=''{0}'', class=''{4}'', data=''{5}'', at=''{2, date,HH:mm:ss MM/dd/yyyy}'', reports=''{3}''";
    private static final String jobWasVetoedMessage = "Job VETOED : group=''{1}'', name=''{0}'', class=''{5}'', triggerGroup=''{4}'', triggerName=''{3}'', at=''{2, date,HH:mm:ss MM/dd/yyyy}''";
    private final TechnicalLoggerService logger;
    private final boolean trace;
    private final boolean warning;

    public TechnicalLoggerJobListener(TechnicalLoggerService logger) {
        this.logger = logger;
        this.trace = logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE);
        this.warning = logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING);
    }

    @Override
    public String getName() {
        return "TechnicalLoggerJobListener";
    }

    @Override
    public void jobToBeExecuted(Map<String, Serializable> context) {
        if (this.trace) {
            String jobName = (String)((Object)context.get("jobName"));
            String jobGroup = (String)((Object)context.get("jobGroup"));
            String triggerName = (String)((Object)context.get("triggerName"));
            String triggerGroup = (String)((Object)context.get("triggerGroup"));
            Date triggerNextFireTime = (Date)context.get("triggerNextFireTime");
            Date triggerPreviousFireTime = (Date)context.get("triggerPreviousFireTime");
            String jobType = (String)((Object)context.get("jobType"));
            Integer refireCount = (Integer)context.get("refireCount");
            List jobDataValueAndTypes = (List)((Object)context.get("jobDatas"));
            Object[] args = new Object[]{jobName, jobGroup, new Date(), triggerName, triggerGroup, jobType, jobDataValueAndTypes, triggerPreviousFireTime, triggerNextFireTime, refireCount};
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, MessageFormat.format(jobToBeFiredMessage, args));
        }
    }

    @Override
    public void jobExecutionVetoed(Map<String, Serializable> context) {
        if (this.trace) {
            String jobName = (String)((Object)context.get("jobName"));
            String jobGroup = (String)((Object)context.get("jobGroup"));
            String triggerName = (String)((Object)context.get("triggerName"));
            String triggerGroup = (String)((Object)context.get("triggerGroup"));
            Date triggerNextFireTime = (Date)context.get("triggerNextFireTime");
            Date triggerPreviousFireTime = (Date)context.get("triggerPreviousFireTime");
            String jobType = (String)((Object)context.get("jobType"));
            Integer refireCount = (Integer)context.get("refireCount");
            Object[] args = new Object[]{jobName, jobGroup, new Date(), triggerName, triggerGroup, jobType, triggerPreviousFireTime, triggerNextFireTime, refireCount};
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, MessageFormat.format(jobWasVetoedMessage, args));
        }
    }

    @Override
    public void jobWasExecuted(Map<String, Serializable> context, Exception jobException) {
        String jobName = (String)((Object)context.get("jobName"));
        String jobGroup = (String)((Object)context.get("jobGroup"));
        String triggerName = (String)((Object)context.get("triggerName"));
        String triggerGroup = (String)((Object)context.get("triggerGroup"));
        Date triggerNextFireTime = (Date)context.get("triggerNextFireTime");
        Date triggerPreviousFireTime = (Date)context.get("triggerPreviousFireTime");
        String jobType = (String)((Object)context.get("jobType"));
        String jobResult = (String)((Object)context.get("jobResult"));
        Integer refireCount = (Integer)context.get("refireCount");
        List jobDataValueAndTypes = (List)((Object)context.get("jobDatas"));
        if (jobException != null) {
            if (this.warning) {
                Object[] args = new Object[]{jobName, jobGroup, new Date(), jobException.getMessage(), jobType, jobDataValueAndTypes, triggerName, triggerGroup, triggerPreviousFireTime, triggerNextFireTime, refireCount};
                this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, MessageFormat.format(jobFailedMessage, args), jobException);
            }
        } else if (this.trace) {
            Object[] args = new Object[]{jobName, jobGroup, new Date(), jobResult, jobType, jobDataValueAndTypes, triggerName, triggerGroup, triggerPreviousFireTime, triggerNextFireTime, refireCount};
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, MessageFormat.format(jobSuccessMessage, args));
        }
    }
}

