/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.search;

import java.util.List;
import org.bonitasoft.engine.bpm.flownode.ActivityInstance;
import org.bonitasoft.engine.bpm.flownode.FlowNodeType;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SAutomaticTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SHumanTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SManualTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SReceiveTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SUserTaskInstance;
import org.bonitasoft.engine.execution.state.FlowNodeStateManager;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.search.AbstractSearchEntity;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.descriptor.SearchEntityDescriptor;
import org.bonitasoft.engine.search.impl.SearchFilter;
import org.bonitasoft.engine.service.ModelConvertor;

public abstract class AbstractActivityInstanceSearchEntity
extends AbstractSearchEntity<ActivityInstance, SActivityInstance> {
    private final FlowNodeStateManager flowNodeStateManager;
    private final Class<? extends PersistentObject> entityClass;

    public AbstractActivityInstanceSearchEntity(SearchEntityDescriptor searchDescriptor, SearchOptions options, FlowNodeStateManager flowNodeStateManager) {
        super(searchDescriptor, options);
        this.flowNodeStateManager = flowNodeStateManager;
        this.entityClass = this.getEntityClass(options);
    }

    @Override
    public List<ActivityInstance> convertToClientObjects(List<SActivityInstance> serverObjects) {
        return ModelConvertor.toActivityInstances(serverObjects, this.flowNodeStateManager);
    }

    protected Class<? extends PersistentObject> getEntityClass(SearchOptions searchOptions) {
        FlowNodeType activityType;
        Class<SActivityInstance> entityClass = SActivityInstance.class;
        SearchFilter searchFilter = this.getSearchFilter(searchOptions, "activityType");
        if (searchFilter != null && (activityType = (FlowNodeType)searchFilter.getValue()) != null) {
            switch (activityType) {
                case AUTOMATIC_TASK: {
                    entityClass = SAutomaticTaskInstance.class;
                    break;
                }
                case MANUAL_TASK: {
                    entityClass = SManualTaskInstance.class;
                    break;
                }
                case USER_TASK: {
                    entityClass = SUserTaskInstance.class;
                    break;
                }
                case HUMAN_TASK: {
                    entityClass = SHumanTaskInstance.class;
                    break;
                }
                case RECEIVE_TASK: {
                    entityClass = SReceiveTaskInstance.class;
                    break;
                }
                default: {
                    entityClass = SActivityInstance.class;
                }
            }
            searchOptions.getFilters().remove(searchFilter);
        }
        return entityClass;
    }

    protected Class<? extends PersistentObject> getEntityClass() {
        return this.entityClass;
    }
}

