/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.search.identity;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.identity.CustomUserInfoValue;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.model.SCustomUserInfoValue;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.search.AbstractSearchEntity;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.descriptor.SearchEntityDescriptor;
import org.bonitasoft.engine.service.ModelConvertor;

public class SearchCustomUserInfoValues
extends AbstractSearchEntity<CustomUserInfoValue, SCustomUserInfoValue> {
    private final IdentityService service;

    public SearchCustomUserInfoValues(IdentityService service, SearchEntityDescriptor searchDescriptor, SearchOptions options) {
        super(searchDescriptor, options);
        this.service = service;
    }

    @Override
    public long executeCount(QueryOptions options) throws SBonitaReadException {
        return this.service.getNumberOfCustomUserInfoValue(options);
    }

    @Override
    public List<SCustomUserInfoValue> executeSearch(QueryOptions options) throws SBonitaReadException {
        return this.service.searchCustomUserInfoValue(options);
    }

    @Override
    public List<CustomUserInfoValue> convertToClientObjects(List<SCustomUserInfoValue> sValues) {
        ArrayList<CustomUserInfoValue> values = new ArrayList<CustomUserInfoValue>(sValues.size());
        for (SCustomUserInfoValue value : sValues) {
            values.add((CustomUserInfoValue)ModelConvertor.convert(value));
        }
        return values;
    }
}

