/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.service.impl;

import java.io.IOException;
import java.util.Properties;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.home.BonitaHomeServer;
import org.bonitasoft.engine.platform.authentication.PlatformAuthenticationService;
import org.bonitasoft.engine.platform.authentication.SInvalidPasswordException;
import org.bonitasoft.engine.platform.authentication.SInvalidUserException;

public class PlatformAuthenticationChecker
implements PlatformAuthenticationService {
    @Override
    public void checkUserCredentials(String userName, String password) throws SInvalidUserException, SInvalidPasswordException {
        try {
            Properties properties = BonitaHomeServer.getInstance().getPlatformProperties();
            String userProperty = properties.getProperty("platformAdminUsername");
            if (userProperty == null || !userProperty.equals(userName)) {
                throw new SInvalidUserException("Invalid user: " + userName);
            }
            String passProperty = properties.getProperty("platformAdminPassword");
            if (passProperty == null || !passProperty.equals(password)) {
                throw new SInvalidPasswordException("Invalid password");
            }
        }
        catch (BonitaHomeNotSetException bhnse) {
            throw new SInvalidUserException(bhnse);
        }
        catch (IOException ioe) {
            throw new SInvalidUserException(ioe);
        }
    }
}

