/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.work;

import java.util.Collection;
import java.util.HashSet;
import org.bonitasoft.engine.sessionaccessor.STenantIdNotSetException;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.transaction.BonitaTransactionSynchronization;
import org.bonitasoft.engine.transaction.TransactionState;
import org.bonitasoft.engine.work.BonitaExecutorService;
import org.bonitasoft.engine.work.BonitaWork;
import org.bonitasoft.engine.work.WorkService;

public abstract class AbstractWorkSynchronization
implements BonitaTransactionSynchronization {
    private final Collection<BonitaWork> works;
    protected final BonitaExecutorService executorService;
    protected final WorkService workService;
    private long tenantId;

    public AbstractWorkSynchronization(BonitaExecutorService executorService, SessionAccessor sessionAccessor, WorkService workService) {
        this.executorService = executorService;
        this.works = new HashSet<BonitaWork>();
        try {
            this.tenantId = sessionAccessor.getTenantId();
        }
        catch (STenantIdNotSetException e) {
            this.tenantId = -1L;
        }
        this.workService = workService;
    }

    public long getTenantId() {
        return this.tenantId;
    }

    public void addWork(BonitaWork work) {
        this.works.add(work);
    }

    @Override
    public void beforeCommit() {
    }

    @Override
    public void afterCompletion(TransactionState transactionStatus) {
        if (TransactionState.COMMITTED == transactionStatus) {
            for (BonitaWork work : this.works) {
                work.setTenantId(this.tenantId);
            }
            this.executeRunnables(this.works);
        }
        this.workService.removeSynchronization();
    }

    protected abstract void executeRunnables(Collection<BonitaWork> var1);
}

