/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.work;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkerThreadFactory
implements ThreadFactory {
    private final AtomicInteger nbThread = new AtomicInteger(1);
    private final String name;
    private final int padding;
    private final long tenantId;

    public WorkerThreadFactory(String name, long tenantId, int maximumPoolSize) {
        this.name = name;
        this.tenantId = tenantId;
        this.padding = WorkerThreadFactory.guessPadding(maximumPoolSize);
    }

    static int guessPadding(int maximumPoolSize) {
        int tmpPadding = 0;
        int poolSize = maximumPoolSize;
        while (poolSize > 0) {
            poolSize /= 10;
            ++tmpPadding;
        }
        return tmpPadding;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        builder.append("-");
        builder.append(this.tenantId);
        builder.append("-");
        builder.append("%0");
        builder.append(this.padding);
        builder.append("d");
        String format = String.format(builder.toString(), this.nbThread.getAndIncrement());
        return new Thread(runnable, format);
    }
}

