/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.util.concurrent.Callable;
import org.bonitasoft.engine.commons.exceptions.SBonitaRuntimeException;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.platform.PlatformService;
import org.bonitasoft.engine.platform.exception.SPlatformNotFoundException;
import org.bonitasoft.engine.platform.model.SPlatform;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.transaction.TransactionService;

public class AbstractLoginApiImpl {
    protected void putPlatformInCacheIfNecessary(final PlatformServiceAccessor platformAccessor, final PlatformService platformService) {
        try {
            platformService.getPlatform();
        }
        catch (SPlatformNotFoundException e1) {
            TransactionService transactionService = platformAccessor.getTransactionService();
            try {
                transactionService.executeInTransaction(new Callable<SPlatform>(){

                    @Override
                    public SPlatform call() throws Exception {
                        try {
                            return platformService.getPlatform();
                        }
                        catch (SPlatformNotFoundException e) {
                            TechnicalLoggerService logger = platformAccessor.getTechnicalLoggerService();
                            if (logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
                                logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Platform not yet created");
                            }
                            throw e;
                        }
                    }
                });
            }
            catch (Exception e) {
                throw new SBonitaRuntimeException(e);
            }
        }
    }
}

