/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.math.NumberUtils;
import org.bonitasoft.engine.api.LoginAPI;
import org.bonitasoft.engine.api.impl.AbstractLoginApiImpl;
import org.bonitasoft.engine.api.impl.transaction.CustomTransactions;
import org.bonitasoft.engine.api.impl.transaction.identity.UpdateUser;
import org.bonitasoft.engine.api.impl.transaction.platform.GetDefaultTenantInstance;
import org.bonitasoft.engine.api.impl.transaction.platform.GetTenantInstance;
import org.bonitasoft.engine.api.impl.transaction.platform.Logout;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.commons.transaction.TransactionExecutor;
import org.bonitasoft.engine.core.login.LoginService;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.identity.model.builder.SUserUpdateBuilder;
import org.bonitasoft.engine.identity.model.builder.SUserUpdateBuilderFactory;
import org.bonitasoft.engine.platform.LoginException;
import org.bonitasoft.engine.platform.LogoutException;
import org.bonitasoft.engine.platform.PlatformService;
import org.bonitasoft.engine.platform.model.STenant;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceSingleton;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.SSessionNotFoundException;
import org.bonitasoft.engine.session.SessionNotFoundException;
import org.bonitasoft.engine.session.model.SSession;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.transaction.TransactionService;
import org.springframework.util.CollectionUtils;

public class LoginAPIImpl
extends AbstractLoginApiImpl
implements LoginAPI {
    @CustomTransactions
    public APISession login(String userName, String password) throws LoginException {
        try {
            return this.loginInternal(userName, password, null);
        }
        catch (LoginException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LoginException((Throwable)e);
        }
    }

    @CustomTransactions
    protected APISession login(String userName, String password, Long tenantId) throws LoginException {
        try {
            return this.loginInternal(userName, password, tenantId);
        }
        catch (LoginException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LoginException((Throwable)e);
        }
    }

    @CustomTransactions
    public APISession login(Map<String, Serializable> credentials) throws LoginException {
        this.checkCredentialsAreNotNullOrEmpty(credentials);
        try {
            Long tenantId = NumberUtils.isNumber((String)String.valueOf(credentials.get("authentication.tenant.id"))) ? Long.valueOf(NumberUtils.toLong((String)String.valueOf(credentials.get("authentication.tenant.id")))) : null;
            return this.loginInternal(tenantId, credentials);
        }
        catch (LoginException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LoginException((Throwable)e);
        }
    }

    protected APISession loginInternal(String userName, String password, Long tenantId) throws Exception {
        this.checkUsernameAndPassword(userName, password);
        HashMap<String, Serializable> credentials = new HashMap<String, Serializable>();
        credentials.put("authentication.username", (Serializable)((Object)userName));
        credentials.put("authentication.password", (Serializable)((Object)password));
        return this.loginInternal(tenantId, credentials);
    }

    protected APISession loginInternal(Long tenantId, Map<String, Serializable> credentials) throws Exception {
        String userName = credentials.get("authentication.username") != null ? String.valueOf(credentials.get("authentication.username")) : null;
        PlatformServiceAccessor platformServiceAccessor = ServiceAccessorFactory.getInstance().createPlatformServiceAccessor();
        STenant sTenant = this.getTenant(tenantId, platformServiceAccessor);
        long localTenantId = sTenant.getId();
        this.checkThatWeCanLogin(userName, sTenant);
        TenantServiceAccessor serviceAccessor = this.getTenantServiceAccessor(localTenantId);
        LoginService loginService = serviceAccessor.getLoginService();
        IdentityService identityService = serviceAccessor.getIdentityService();
        TransactionService transactionService = platformServiceAccessor.getTransactionService();
        HashMap<String, Serializable> credentialsWithResolvedTenantId = new HashMap<String, Serializable>(credentials);
        credentialsWithResolvedTenantId.put("authentication.tenant.id", Long.valueOf(localTenantId));
        SSession sSession = transactionService.executeInTransaction(new LoginAndRetrieveUser(loginService, identityService, credentialsWithResolvedTenantId));
        return ModelConvertor.toAPISession(sSession, sTenant.getName());
    }

    protected STenant getTenant(Long tenantId, PlatformServiceAccessor platformServiceAccessor) throws SBonitaException {
        PlatformService platformService = platformServiceAccessor.getPlatformService();
        TransactionExecutor platformTransactionExecutor = platformServiceAccessor.getTransactionExecutor();
        TransactionContentWithResult<STenant> getTenant = tenantId == null ? new GetDefaultTenantInstance(platformService) : new GetTenantInstance(tenantId, platformService);
        platformTransactionExecutor.execute(getTenant);
        return getTenant.getResult();
    }

    protected void checkUsernameAndPassword(String userName, String password) throws LoginException {
        if (userName == null || userName.isEmpty()) {
            throw new LoginException("User name is null or empty !! ");
        }
        if (password == null || password.isEmpty()) {
            throw new LoginException("Password is null or empty !!");
        }
    }

    protected void checkCredentialsAreNotNullOrEmpty(Map<String, Serializable> credentials) throws LoginException {
        if (CollectionUtils.isEmpty(credentials)) {
            throw new LoginException("Credentials are null or empty !!");
        }
    }

    protected void checkThatWeCanLogin(String userName, STenant sTenant) throws LoginException {
        if (!sTenant.isActivated()) {
            throw new LoginException("Tenant " + sTenant.getName() + " is not activated !!");
        }
    }

    protected TenantServiceAccessor getTenantServiceAccessor(long tenantId) {
        return TenantServiceSingleton.getInstance(tenantId);
    }

    @CustomTransactions
    public void logout(APISession session) throws LogoutException, SessionNotFoundException {
        TenantServiceAccessor serviceAccessor = this.getTenantServiceAccessor(session.getTenantId());
        TransactionExecutor transactionExecutor = serviceAccessor.getTransactionExecutor();
        Logout logout = new Logout(serviceAccessor.getLoginService(), session.getId());
        try {
            transactionExecutor.execute(logout);
        }
        catch (SSessionNotFoundException sbe) {
            throw new SessionNotFoundException((Throwable)sbe);
        }
        catch (SBonitaException sbe) {
            throw new LogoutException((Throwable)sbe);
        }
    }

    private class LoginAndRetrieveUser
    implements Callable<SSession> {
        private final LoginService loginService;
        private final IdentityService identityService;
        private final Map<String, Serializable> credentials;

        public LoginAndRetrieveUser(LoginService loginService, IdentityService identityService, Map<String, Serializable> credentials) {
            this.loginService = loginService;
            this.identityService = identityService;
            this.credentials = credentials;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SSession call() throws Exception {
            SSession session;
            SessionAccessor sessionAccessor = null;
            try {
                session = this.loginService.login(this.credentials);
                if (!session.isTechnicalUser()) {
                    Long tenantId = NumberUtils.toLong((String)String.valueOf(this.credentials.get("authentication.tenant.id")), (long)0L);
                    sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
                    sessionAccessor.setSessionInfo(session.getId(), tenantId);
                    SUser sUser = this.identityService.getUserByUserName(session.getUserName());
                    if (!sUser.isEnabled()) {
                        throw new LoginException("Unable to login : the user is disable.");
                    }
                    SUserUpdateBuilder userUpdateBuilder = BuilderFactory.get(SUserUpdateBuilderFactory.class).createNewInstance();
                    long lastConnection = System.currentTimeMillis();
                    EntityUpdateDescriptor updateDescriptor = userUpdateBuilder.updateLastConnection(lastConnection).done();
                    UpdateUser updateUser = new UpdateUser(this.identityService, sUser.getId(), updateDescriptor, null, null);
                    updateUser.execute();
                }
            }
            finally {
                if (sessionAccessor != null) {
                    sessionAccessor.deleteSessionId();
                }
            }
            return session;
        }
    }
}

