/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.io.IOException;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.bonitasoft.engine.api.NoSessionRequired;
import org.bonitasoft.engine.api.PlatformAPI;
import org.bonitasoft.engine.api.impl.AvailableOnStoppedNode;
import org.bonitasoft.engine.api.impl.ServerAPIRuntimeException;
import org.bonitasoft.engine.api.impl.transaction.CustomTransactions;
import org.bonitasoft.engine.api.internal.ServerAPI;
import org.bonitasoft.engine.api.internal.ServerWrappedException;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.classloader.SClassLoaderException;
import org.bonitasoft.engine.commons.ClassReflector;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.login.LoginService;
import org.bonitasoft.engine.core.platform.login.PlatformLoginService;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.exception.BonitaContextException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeConfigurationException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.platform.NodeNotStartedException;
import org.bonitasoft.engine.platform.PlatformService;
import org.bonitasoft.engine.platform.session.PlatformSessionService;
import org.bonitasoft.engine.platform.session.SSessionException;
import org.bonitasoft.engine.scheduler.SchedulerService;
import org.bonitasoft.engine.scheduler.exception.SSchedulerException;
import org.bonitasoft.engine.service.APIAccessResolver;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.bonitasoft.engine.session.PlatformSession;
import org.bonitasoft.engine.session.Session;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.transaction.UserTransactionService;

public class ServerAPIImpl
implements ServerAPI {
    private static final String SESSION = "session";
    private static final String IS_NODE_STARTED_METHOD_NAME = "isNodeStarted";
    private static final long serialVersionUID = -161775388604256321L;
    protected final APIAccessResolver accessResolver;
    private final boolean cleanSession;
    private TechnicalLoggerService technicalLogger;

    public ServerAPIImpl() {
        this(true);
    }

    public ServerAPIImpl(boolean cleanSession) {
        try {
            this.cleanSession = cleanSession;
            this.accessResolver = this.getServiceAccessorFactoryInstance().createAPIAccessResolver();
        }
        catch (Exception e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
    }

    public ServerAPIImpl(boolean cleanSession, APIAccessResolver accessResolver) {
        this.cleanSession = cleanSession;
        this.accessResolver = accessResolver;
    }

    void setTechnicalLogger(TechnicalLoggerService technicalLoggerService) {
        this.technicalLogger = technicalLoggerService;
    }

    private ServiceAccessorFactory getServiceAccessorFactoryInstance() {
        return ServiceAccessorFactory.getInstance();
    }

    public Object invokeMethod(Map<String, Serializable> options, String apiInterfaceName, String methodName, List<String> classNameParameters, Object[] parametersValues) throws ServerWrappedException {
        Object object;
        this.technicalTraceLog("Starting ", apiInterfaceName, methodName);
        ClassLoader baseClassLoader = Thread.currentThread().getContextClassLoader();
        SessionAccessor sessionAccessor = null;
        Session session = null;
        try {
            session = (Session)options.get(SESSION);
            sessionAccessor = this.beforeInvokeMethod(session, apiInterfaceName);
            object = this.invokeAPI(apiInterfaceName, methodName, classNameParameters, parametersValues, session);
        }
        catch (ServerAPIRuntimeException sapire) {
            try {
                try {
                    throw sapire.getCause();
                }
                catch (BonitaRuntimeException bre) {
                    this.fillGlobalContextForException(session, (BonitaContextException)bre);
                    throw this.createServerWrappedException(bre);
                }
                catch (BonitaException be) {
                    this.fillGlobalContextForException(session, (BonitaContextException)be);
                    throw this.createServerWrappedException(be);
                }
                catch (UndeclaredThrowableException ute) {
                    this.technicalDebugLog(ute);
                    throw this.createServerWrappedException(ute);
                }
                catch (Throwable cause) {
                    this.technicalDebugLog(cause);
                    BonitaRuntimeException throwableToWrap = new BonitaRuntimeException(cause);
                    this.fillGlobalContextForException(session, (BonitaContextException)throwableToWrap);
                    throw this.createServerWrappedException(throwableToWrap);
                }
            }
            catch (Throwable throwable) {
                this.cleanSessionIfNeeded(sessionAccessor);
                Thread.currentThread().setContextClassLoader(baseClassLoader);
                this.technicalTraceLog("End ", apiInterfaceName, methodName);
                throw throwable;
            }
        }
        this.cleanSessionIfNeeded(sessionAccessor);
        Thread.currentThread().setContextClassLoader(baseClassLoader);
        this.technicalTraceLog("End ", apiInterfaceName, methodName);
        return object;
    }

    private ServerWrappedException createServerWrappedException(Throwable throwableToWrap) {
        return new ServerWrappedException(throwableToWrap);
    }

    private void fillGlobalContextForException(Session session, BonitaContextException be) {
        this.fillUserNameContextForException(session, be);
    }

    private void fillUserNameContextForException(Session session, BonitaContextException be) {
        String userName;
        if (session != null && (userName = session.getUserName()) != null) {
            be.setUserName(userName);
        }
    }

    private void cleanSessionIfNeeded(SessionAccessor sessionAccessor) {
        if (this.cleanSession && sessionAccessor != null) {
            sessionAccessor.deleteSessionId();
        }
    }

    private void technicalDebugLog(Throwable throwableToLog) {
        if (this.technicalLogger != null && this.technicalLogger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            this.technicalLogger.log(this.getClass(), TechnicalLogSeverity.DEBUG, throwableToLog);
        }
    }

    private void technicalTraceLog(String prefix, String apiInterfaceName, String methodName) {
        if (this.technicalLogger != null && this.technicalLogger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.technicalLogger.log(this.getClass(), TechnicalLogSeverity.TRACE, prefix + "Server API call " + apiInterfaceName + " " + methodName);
        }
    }

    SessionAccessor beforeInvokeMethod(Session session, String apiInterfaceName) throws BonitaHomeNotSetException, InstantiationException, IllegalAccessException, ClassNotFoundException, BonitaHomeConfigurationException, IOException, NoSuchMethodException, InvocationTargetException, SBonitaException {
        SessionAccessor sessionAccessor = null;
        ServiceAccessorFactory serviceAccessorFactory = this.getServiceAccessorFactoryInstance();
        PlatformServiceAccessor platformServiceAccessor = serviceAccessorFactory.createPlatformServiceAccessor();
        ClassLoader serverClassLoader = null;
        if (session != null) {
            SessionType sessionType = this.getSessionType(session);
            sessionAccessor = serviceAccessorFactory.createSessionAccessor();
            switch (sessionType) {
                case PLATFORM: {
                    serverClassLoader = this.beforeInvokeMethodForPlatformSession(sessionAccessor, platformServiceAccessor, session);
                    break;
                }
                case API: {
                    serverClassLoader = this.beforeInvokeMethodForAPISession(sessionAccessor, serviceAccessorFactory, platformServiceAccessor, session);
                    break;
                }
                default: {
                    throw new InvalidSessionException("Unknown session type: " + session.getClass().getName());
                }
            }
        } else if (this.accessResolver.needSession(apiInterfaceName)) {
            throw new InvalidSessionException("Session is null!");
        }
        if (serverClassLoader != null) {
            Thread.currentThread().setContextClassLoader(serverClassLoader);
        }
        return sessionAccessor;
    }

    private ClassLoader beforeInvokeMethodForAPISession(SessionAccessor sessionAccessor, ServiceAccessorFactory serviceAccessorFactory, PlatformServiceAccessor platformServiceAccessor, Session session) throws SBonitaException, BonitaHomeNotSetException, IOException, BonitaHomeConfigurationException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        SessionService sessionService = platformServiceAccessor.getSessionService();
        this.checkTenantSession(platformServiceAccessor, session);
        sessionService.renewSession(session.getId());
        sessionAccessor.setSessionInfo(session.getId(), ((APISession)session).getTenantId());
        ClassLoader serverClassLoader = this.getTenantClassLoader(platformServiceAccessor, session);
        this.setTechnicalLogger(serviceAccessorFactory.createTenantServiceAccessor(((APISession)session).getTenantId()).getTechnicalLoggerService());
        return serverClassLoader;
    }

    private ClassLoader beforeInvokeMethodForPlatformSession(SessionAccessor sessionAccessor, PlatformServiceAccessor platformServiceAccessor, Session session) throws SSessionException, SClassLoaderException {
        PlatformSessionService platformSessionService = platformServiceAccessor.getPlatformSessionService();
        PlatformLoginService loginService = platformServiceAccessor.getPlatformLoginService();
        if (!loginService.isValid(session.getId())) {
            throw new InvalidSessionException("Invalid session");
        }
        platformSessionService.renewSession(session.getId());
        sessionAccessor.setSessionInfo(session.getId(), -1L);
        ClassLoader serverClassLoader = this.getPlatformClassLoader(platformServiceAccessor);
        this.setTechnicalLogger(platformServiceAccessor.getTechnicalLoggerService());
        return serverClassLoader;
    }

    protected SessionType getSessionType(Session session) {
        SessionType sessionType = null;
        if (session instanceof PlatformSession) {
            sessionType = SessionType.PLATFORM;
        } else if (session instanceof APISession) {
            sessionType = SessionType.API;
        }
        return sessionType;
    }

    Object invokeAPI(String apiInterfaceName, String methodName, List<String> classNameParameters, Object[] parametersValues, Session session) throws Throwable {
        Class<?>[] parameterTypes = this.getParameterTypes(classNameParameters);
        Object apiImpl = this.accessResolver.getAPIImplementation(apiInterfaceName);
        Method method = ClassReflector.getMethod(apiImpl.getClass(), methodName, parameterTypes);
        if (method.isAnnotationPresent(CustomTransactions.class) || method.isAnnotationPresent(NoSessionRequired.class)) {
            return this.invokeAPIOutsideTransaction(parametersValues, apiImpl, method, apiInterfaceName, session);
        }
        return this.invokeAPIInTransaction(parametersValues, apiImpl, method, session, apiInterfaceName);
    }

    protected Object invokeAPIOutsideTransaction(Object[] parametersValues, Object apiImpl, Method method, String apiInterfaceName, Session session) throws Throwable {
        this.checkMethodAccessibility(apiImpl, apiInterfaceName, method, session, false);
        return this.invokeAPI(parametersValues, apiImpl, method);
    }

    protected void checkMethodAccessibility(Object apiImpl, String apiInterfaceName, Method method, Session session, boolean isInTransaction) {
        if (!this.isNodeInAValidStateFor(method)) {
            this.logNodeNotStartedMessage(apiInterfaceName, method.getName());
            throw new NodeNotStartedException();
        }
    }

    protected void logNodeNotStartedMessage(String apiInterfaceName, String methodName) {
        this.logTechnicalErrorMessage("Node not started. Method '" + apiInterfaceName + "." + methodName + "' cannot be called until node has been started (PlatformAPI.startNode())");
    }

    protected void logTechnicalErrorMessage(String message) {
        if (this.technicalLogger != null) {
            this.technicalLogger.log(this.getClass(), TechnicalLogSeverity.ERROR, message);
        } else {
            System.err.println(message);
        }
    }

    protected boolean isNodeInAValidStateFor(Method method) {
        return method.isAnnotationPresent(AvailableOnStoppedNode.class) || this.isNodeStarted();
    }

    private boolean isNodeStarted() {
        try {
            Object apiImpl = this.accessResolver.getAPIImplementation(PlatformAPI.class.getName());
            Method method = ClassReflector.getMethod(apiImpl.getClass(), IS_NODE_STARTED_METHOD_NAME, new Class[0]);
            return (Boolean)this.invokeAPI(new Object[0], apiImpl, method);
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected Object invokeAPIInTransaction(final Object[] parametersValues, final Object apiImpl, final Method method, final Session session, final String apiInterfaceName) throws Throwable {
        if (session == null) {
            throw new BonitaRuntimeException("session is null");
        }
        UserTransactionService userTransactionService = this.selectUserTransactionService(session, this.getSessionType(session));
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    ServerAPIImpl.this.checkMethodAccessibility(apiImpl, apiInterfaceName, method, session, true);
                    return ServerAPIImpl.this.invokeAPI(parametersValues, apiImpl, method);
                }
                catch (Throwable cause) {
                    throw new ServerAPIRuntimeException(cause);
                }
            }
        };
        return userTransactionService.executeInTransaction(callable);
    }

    protected UserTransactionService selectUserTransactionService(Session session, SessionType sessionType) throws BonitaHomeNotSetException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException, BonitaHomeConfigurationException {
        UserTransactionService transactionService = null;
        ServiceAccessorFactory serviceAccessorFactory = this.getServiceAccessorFactoryInstance();
        PlatformServiceAccessor platformServiceAccessor = serviceAccessorFactory.createPlatformServiceAccessor();
        switch (sessionType) {
            case PLATFORM: {
                transactionService = platformServiceAccessor.getTransactionService();
                break;
            }
            case API: {
                TenantServiceAccessor tenantAccessor = platformServiceAccessor.getTenantServiceAccessor(((APISession)session).getTenantId());
                transactionService = tenantAccessor.getUserTransactionService();
                break;
            }
            default: {
                throw new InvalidSessionException("Unknown session type: " + session.getClass().getName());
            }
        }
        return transactionService;
    }

    protected Object invokeAPI(Object[] parametersValues, Object apiImpl, Method method) throws Throwable {
        try {
            return method.invoke(apiImpl, parametersValues);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    protected Class<?>[] getParameterTypes(List<String> classNameParameters) throws ClassNotFoundException {
        Class[] parameterTypes = null;
        if (classNameParameters != null && !classNameParameters.isEmpty()) {
            parameterTypes = new Class[classNameParameters.size()];
            for (int i = 0; i < parameterTypes.length; ++i) {
                String className = classNameParameters.get(i);
                Class<Constable> classType = null;
                classType = "int".equals(className) ? Integer.TYPE : ("long".equals(className) ? Long.TYPE : ("boolean".equals(className) ? Boolean.TYPE : Class.forName(className)));
                parameterTypes[i] = classType;
            }
        }
        return parameterTypes;
    }

    private void checkTenantSession(PlatformServiceAccessor platformAccessor, Session session) throws SSchedulerException {
        APISession apiSession;
        TenantServiceAccessor tenantAccessor;
        LoginService tenantLoginService;
        SchedulerService schedulerService = platformAccessor.getSchedulerService();
        TechnicalLoggerService logger = platformAccessor.getTechnicalLoggerService();
        if (!schedulerService.isStarted() && logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "The scheduler is not started!");
        }
        if (!(tenantLoginService = (tenantAccessor = platformAccessor.getTenantServiceAccessor((apiSession = (APISession)session).getTenantId())).getLoginService()).isValid(apiSession.getId())) {
            throw new InvalidSessionException("Invalid session");
        }
    }

    private ClassLoader getTenantClassLoader(PlatformServiceAccessor platformServiceAccessor, Session session) throws SClassLoaderException {
        APISession apiSession = (APISession)session;
        TenantServiceAccessor tenantAccessor = platformServiceAccessor.getTenantServiceAccessor(apiSession.getTenantId());
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        return classLoaderService.getLocalClassLoader(ScopeType.TENANT.name(), apiSession.getTenantId());
    }

    private ClassLoader getPlatformClassLoader(PlatformServiceAccessor platformServiceAccessor) throws SClassLoaderException {
        ClassLoader classLoader = null;
        final PlatformService platformService = platformServiceAccessor.getPlatformService();
        if (!platformService.isPlatformCreated()) {
            try {
                platformServiceAccessor.getTransactionService().executeInTransaction(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        platformService.getPlatform();
                        return null;
                    }
                });
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (platformService.isPlatformCreated()) {
            ClassLoaderService classLoaderService = platformServiceAccessor.getClassLoaderService();
            classLoader = classLoaderService.getGlobalClassLoader();
        }
        return classLoader;
    }

    protected static enum SessionType {
        PLATFORM,
        API;

    }
}

