/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.platform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bonitasoft.engine.api.impl.NodeConfiguration;
import org.bonitasoft.engine.api.impl.TenantConfiguration;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.connector.ConnectorExecutor;
import org.bonitasoft.engine.jobs.BPMEventHandlingJob;
import org.bonitasoft.engine.jobs.CleanInvalidSessionsJob;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.platform.PlatformService;
import org.bonitasoft.engine.scheduler.JobRegister;
import org.bonitasoft.engine.scheduler.SchedulerService;
import org.bonitasoft.engine.scheduler.builder.SJobDescriptorBuilderFactory;
import org.bonitasoft.engine.scheduler.builder.SJobParameterBuilderFactory;
import org.bonitasoft.engine.scheduler.exception.SSchedulerException;
import org.bonitasoft.engine.scheduler.model.SJobDescriptor;
import org.bonitasoft.engine.scheduler.model.SJobParameter;
import org.bonitasoft.engine.scheduler.trigger.Trigger;
import org.bonitasoft.engine.scheduler.trigger.UnixCronTrigger;
import org.bonitasoft.engine.work.WorkService;

public final class ActivateTenant
implements TransactionContent {
    public static final String CLEAN_INVALID_SESSIONS = "CleanInvalidSessions";
    public static final String BPM_EVENT_HANDLING = "BPMEventHandling";
    private final long tenantId;
    private final PlatformService platformService;
    private final SchedulerService schedulerService;
    private final TechnicalLoggerService logger;
    private final WorkService workService;
    private final ConnectorExecutor connectorExecutor;
    private final TenantConfiguration tenantConfiguration;
    private final NodeConfiguration nodeConfiguration;

    public ActivateTenant(long tenantId, PlatformService platformService, SchedulerService schedulerService, TechnicalLoggerService logger, WorkService workService, ConnectorExecutor connectorExecutor, NodeConfiguration plaformConfiguration, TenantConfiguration tenantConfiguration) {
        this.tenantId = tenantId;
        this.platformService = platformService;
        this.schedulerService = schedulerService;
        this.logger = logger;
        this.workService = workService;
        this.connectorExecutor = connectorExecutor;
        this.nodeConfiguration = plaformConfiguration;
        this.tenantConfiguration = tenantConfiguration;
    }

    @Override
    public void execute() throws SBonitaException {
        boolean tenantWasActivated = this.platformService.activateTenant(this.tenantId);
        if (tenantWasActivated) {
            this.workService.start();
            this.connectorExecutor.start();
            this.startEventHandling();
            this.startCleanInvalidSessionsJob();
            List<JobRegister> jobsToRegister = this.tenantConfiguration.getJobsToRegister();
            for (JobRegister jobRegister : jobsToRegister) {
                this.registerJob(jobRegister);
            }
        }
    }

    private void registerJob(JobRegister jobRegister) {
        block6: {
            try {
                List<String> jobs = this.schedulerService.getAllJobs();
                if (!jobs.contains(jobRegister.getJobName())) {
                    if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
                        this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Register " + jobRegister.getJobDescription());
                    }
                    SJobDescriptor jobDescriptor = BuilderFactory.get(SJobDescriptorBuilderFactory.class).createNewInstance(jobRegister.getJobClass().getName(), jobRegister.getJobName(), true).done();
                    ArrayList<SJobParameter> jobParameters = new ArrayList<SJobParameter>();
                    for (Map.Entry<String, Serializable> entry : jobRegister.getJobParameters().entrySet()) {
                        jobParameters.add(BuilderFactory.get(SJobParameterBuilderFactory.class).createNewInstance(entry.getKey(), entry.getValue()).done());
                    }
                    Trigger trigger = jobRegister.getTrigger();
                    this.schedulerService.schedule(jobDescriptor, jobParameters, trigger);
                } else {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "The " + jobRegister.getJobDescription() + " was already started");
                }
            }
            catch (SSchedulerException e) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.ERROR, "Unable to register job " + jobRegister.getJobDescription() + " because " + e.getMessage());
                if (!this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) break block6;
                this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, e);
            }
        }
    }

    private void startEventHandling() throws SSchedulerException {
        String jobClassName = BPMEventHandlingJob.class.getName();
        if (this.schedulerService.isStarted()) {
            if (this.nodeConfiguration.shouldStartEventHandlingJob()) {
                SJobDescriptor jobDescriptor = BuilderFactory.get(SJobDescriptorBuilderFactory.class).createNewInstance(jobClassName, BPM_EVENT_HANDLING, true).done();
                ArrayList<SJobParameter> jobParameters = new ArrayList<SJobParameter>();
                String cron = this.tenantConfiguration.getEventHandlingJobCron();
                UnixCronTrigger trigger = new UnixCronTrigger("UnixCronTrigger" + UUID.randomUUID().getLeastSignificantBits(), new Date(), cron, Trigger.MisfireRestartPolicy.NONE);
                if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Starting event handling job with frequency : " + cron);
                }
                this.schedulerService.schedule(jobDescriptor, jobParameters, trigger);
            }
        } else if (this.logger.isLoggable(ActivateTenant.class, TechnicalLogSeverity.WARNING)) {
            this.logger.log(ActivateTenant.class, TechnicalLogSeverity.WARNING, "The scheduler is not started: impossible to schedule job " + jobClassName);
        }
    }

    private void startCleanInvalidSessionsJob() throws SSchedulerException {
        String jobClassName = CleanInvalidSessionsJob.class.getName();
        if (this.schedulerService.isStarted()) {
            String cron = this.tenantConfiguration.getCleanInvalidSessionsJobCron();
            if (!cron.equalsIgnoreCase("none")) {
                SJobDescriptor jobDescriptor = BuilderFactory.get(SJobDescriptorBuilderFactory.class).createNewInstance(jobClassName, CLEAN_INVALID_SESSIONS, true).done();
                ArrayList<SJobParameter> jobParameters = new ArrayList<SJobParameter>();
                UnixCronTrigger trigger = new UnixCronTrigger("UnixCronTrigger" + UUID.randomUUID().getLeastSignificantBits(), new Date(), cron, Trigger.MisfireRestartPolicy.NONE);
                if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Starting clean invalid sessions job with frequency : " + cron);
                }
                this.schedulerService.schedule(jobDescriptor, jobParameters, trigger);
            }
        } else if (this.logger.isLoggable(ActivateTenant.class, TechnicalLogSeverity.WARNING)) {
            this.logger.log(ActivateTenant.class, TechnicalLogSeverity.WARNING, "The scheduler is not started: impossible to schedule job " + jobClassName);
        }
    }
}

