/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.platform;

import java.util.List;
import org.bonitasoft.engine.command.CommandCriterion;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.platform.command.PlatformCommandService;
import org.bonitasoft.engine.platform.command.model.SPlatformCommand;

public class GetSPlatformCommands
implements TransactionContentWithResult<List<SPlatformCommand>> {
    private final PlatformCommandService platformCommandService;
    private final int startIndex;
    private final int maxResults;
    private final CommandCriterion sort;
    private List<SPlatformCommand> platformCommands;

    public GetSPlatformCommands(PlatformCommandService platformCommandService, int startIndex, int maxResults, CommandCriterion sort) {
        this.platformCommandService = platformCommandService;
        this.startIndex = startIndex;
        this.maxResults = maxResults;
        this.sort = sort;
    }

    @Override
    public void execute() throws SBonitaException {
        QueryOptions queryOptions;
        switch (this.sort) {
            case NAME_ASC: {
                queryOptions = new QueryOptions(this.startIndex, this.maxResults, SPlatformCommand.class, "name", OrderByType.ASC);
                break;
            }
            default: {
                queryOptions = new QueryOptions(this.startIndex, this.maxResults, SPlatformCommand.class, "name", OrderByType.DESC);
            }
        }
        this.platformCommands = this.platformCommandService.getPlatformCommands(queryOptions);
    }

    @Override
    public List<SPlatformCommand> getResult() {
        return this.platformCommands;
    }
}

