/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.profile;

import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.MemberType;
import org.bonitasoft.engine.identity.SGroupNotFoundException;
import org.bonitasoft.engine.identity.SRoleNotFoundException;
import org.bonitasoft.engine.identity.SUserNotFoundException;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.identity.model.SRole;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.profile.exception.profilemember.SProfileMemberCreationException;
import org.bonitasoft.engine.profile.model.SProfileMember;

public class CreateProfileMember
implements TransactionContentWithResult<SProfileMember> {
    private final ProfileService profileService;
    private final IdentityService identityService;
    private final long profileId;
    private final Long userId;
    private final Long groupId;
    private final Long roleId;
    private final MemberType memberType;
    private SProfileMember sProfileMember;

    public CreateProfileMember(ProfileService profileService, IdentityService identityService, long profileId, Long userId, Long groupId, Long roleId, MemberType memberType) {
        this.profileService = profileService;
        this.identityService = identityService;
        this.profileId = profileId;
        this.userId = userId;
        this.groupId = groupId;
        this.roleId = roleId;
        this.memberType = memberType;
    }

    @Override
    public void execute() throws SBonitaException {
        this.profileService.updateProfileMetaData(this.profileId);
        switch (this.memberType) {
            case USER: {
                if (!this.isNotNullOrEmpty(this.userId)) break;
                this.addUserToProfile();
                break;
            }
            case GROUP: {
                if (!this.isNotNullOrEmpty(this.groupId)) break;
                this.addGroupToProfile();
                break;
            }
            case ROLE: {
                if (!this.isNotNullOrEmpty(this.roleId)) break;
                this.addRoleToProfile();
                break;
            }
            default: {
                if (!this.isNotNullOrEmpty(this.groupId) || !this.isNotNullOrEmpty(this.roleId)) break;
                this.addRoleAndGroupToProfile();
            }
        }
    }

    private void addRoleAndGroupToProfile() throws SGroupNotFoundException, SRoleNotFoundException, SProfileMemberCreationException {
        SGroup group = this.identityService.getGroup(this.groupId);
        SRole role = this.identityService.getRole(this.roleId);
        if (group != null && role != null) {
            this.sProfileMember = this.profileService.addRoleAndGroupToProfile(this.profileId, this.roleId, this.groupId, role.getName(), group.getName(), group.getParentPath());
        }
    }

    private void addRoleToProfile() throws SRoleNotFoundException, SProfileMemberCreationException {
        SRole role = this.identityService.getRole(this.roleId);
        if (role != null) {
            this.sProfileMember = this.profileService.addRoleToProfile(this.profileId, this.roleId, role.getName());
        }
    }

    private void addGroupToProfile() throws SGroupNotFoundException, SProfileMemberCreationException {
        SGroup group = this.identityService.getGroup(this.groupId);
        if (group != null) {
            this.sProfileMember = this.profileService.addGroupToProfile(this.profileId, this.groupId, group.getName(), group.getParentPath());
        }
    }

    private void addUserToProfile() throws SUserNotFoundException, SProfileMemberCreationException {
        SUser user = this.identityService.getUser(this.userId);
        if (user != null) {
            this.sProfileMember = this.profileService.addUserToProfile(this.profileId, this.userId, user.getUserName(), user.getLastName(), user.getUserName());
        }
    }

    private boolean isNotNullOrEmpty(Long id) {
        return id != null && id > 0L;
    }

    @Override
    public SProfileMember getResult() {
        return this.sProfileMember;
    }
}

