/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.internal.servlet;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.bonitasoft.engine.api.impl.PlatformAPIImpl;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.platform.session.PlatformSessionService;
import org.bonitasoft.engine.platform.session.model.SPlatformSession;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.service.impl.SpringPlatformFileSystemBeanAccessor;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;

public class BonitaServletContextListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        try {
            SpringPlatformFileSystemBeanAccessor.initializeContext(null);
            PlatformServiceAccessor platformAccessor = this.getPlatformAccessor();
            SessionAccessor sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
            PlatformSessionService platformSessionService = platformAccessor.getPlatformSessionService();
            SPlatformSession createSession = platformSessionService.createSession("john");
            sessionAccessor.setSessionInfo(createSession.getId(), -1L);
            PlatformAPIImpl platformAPI = new PlatformAPIImpl();
            if (platformAPI.isPlatformCreated()) {
                platformAPI.startNode();
            }
            platformSessionService.deleteSession(createSession.getId());
            sessionAccessor.deleteSessionId();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected PlatformServiceAccessor getPlatformAccessor() {
        try {
            return ServiceAccessorFactory.getInstance().createPlatformServiceAccessor();
        }
        catch (Exception e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

