/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.classloader;

import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.classloader.ParentClassLoaderResolver;
import org.bonitasoft.engine.classloader.SClassLoaderException;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.sessionaccessor.ReadSessionAccessor;
import org.bonitasoft.engine.sessionaccessor.STenantIdNotSetException;

public class BonitaBPMParentClassLoaderResolver
implements ParentClassLoaderResolver {
    private final ReadSessionAccessor sessionAccessor;

    public BonitaBPMParentClassLoaderResolver(ReadSessionAccessor sessionAccessor) {
        this.sessionAccessor = sessionAccessor;
    }

    @Override
    public ClassLoader getParent(ClassLoaderService classLoaderService, String childClassLoaderType, long childClassLoaderId) throws SClassLoaderException {
        ClassLoader parent;
        block9: {
            parent = null;
            if (ScopeType.PROCESS.name().equals(childClassLoaderType)) {
                try {
                    Long tenantId = this.sessionAccessor.getTenantId();
                    if (tenantId > 0L) {
                        parent = classLoaderService.getLocalClassLoader(ScopeType.TENANT.name(), tenantId);
                        break block9;
                    }
                    parent = classLoaderService.getGlobalClassLoader();
                }
                catch (STenantIdNotSetException e) {
                    parent = classLoaderService.getGlobalClassLoader();
                }
            } else if (ScopeType.TENANT.name().equals(childClassLoaderType)) {
                parent = classLoaderService.getGlobalClassLoader();
            } else if ("___datasource___".equals(childClassLoaderType)) {
                parent = classLoaderService.getGlobalClassLoader();
            } else {
                throw new BonitaRuntimeException("unable to find a parent for type: " + childClassLoaderType);
            }
        }
        return parent;
    }
}

