/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.document.api.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.archive.ArchiveInsertRecord;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.exceptions.SObjectAlreadyExistsException;
import org.bonitasoft.engine.commons.exceptions.SObjectCreationException;
import org.bonitasoft.engine.commons.exceptions.SObjectModificationException;
import org.bonitasoft.engine.commons.exceptions.SObjectNotFoundException;
import org.bonitasoft.engine.core.document.api.DocumentService;
import org.bonitasoft.engine.core.document.api.impl.SDocumentDownloadURLProvider;
import org.bonitasoft.engine.core.document.model.SDocument;
import org.bonitasoft.engine.core.document.model.SDocumentMapping;
import org.bonitasoft.engine.core.document.model.SLightDocument;
import org.bonitasoft.engine.core.document.model.SMappedDocument;
import org.bonitasoft.engine.core.document.model.archive.SADocumentMapping;
import org.bonitasoft.engine.core.document.model.archive.SAMappedDocument;
import org.bonitasoft.engine.core.document.model.archive.impl.SADocumentMappingImpl;
import org.bonitasoft.engine.core.document.model.impl.SDocumentMappingImpl;
import org.bonitasoft.engine.core.document.model.impl.SMappedDocumentImpl;
import org.bonitasoft.engine.core.document.model.recorder.SelectDescriptorBuilder;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;

public class DocumentServiceImpl
implements DocumentService {
    private final SDocumentDownloadURLProvider urlProvider;
    private final EventService eventService;
    private final ArchiveService archiveService;
    private final Recorder recorder;
    private final ReadPersistenceService persistenceService;
    private final ReadPersistenceService definitiveArchiveReadPersistenceService;

    public DocumentServiceImpl(Recorder recorder, ReadPersistenceService persistenceService, SDocumentDownloadURLProvider urlProvider, EventService eventService, ArchiveService archiveService) {
        this.recorder = recorder;
        this.persistenceService = persistenceService;
        this.urlProvider = urlProvider;
        this.eventService = eventService;
        this.archiveService = archiveService;
        this.definitiveArchiveReadPersistenceService = archiveService.getDefinitiveArchiveReadPersistenceService();
    }

    @Override
    public SMappedDocument attachDocumentToProcessInstance(SDocument document, long processInstanceId, String name, String description) throws SObjectCreationException {
        try {
            this.insertDocument(document);
            SDocumentMapping documentMapping = this.create(document.getId(), processInstanceId, name, description, -1);
            return new SMappedDocumentImpl(documentMapping, (SLightDocument)document);
        }
        catch (SBonitaException e) {
            throw new SObjectCreationException(e.getMessage(), e);
        }
    }

    @Override
    public SMappedDocument attachDocumentToProcessInstance(SDocument document, long processInstanceId, String name, String description, int index) throws SObjectCreationException, SObjectAlreadyExistsException {
        try {
            SMappedDocument mappedDocumentInternal;
            if (index == -1 && (mappedDocumentInternal = this.getMappedDocumentInternal(processInstanceId, name)) != null) {
                throw new SObjectAlreadyExistsException("A document already exists with name " + name + " and process instance id " + processInstanceId);
            }
            this.insertDocument(document);
            SDocumentMapping documentMapping = this.create(document.getId(), processInstanceId, name, description, index);
            return new SMappedDocumentImpl(documentMapping, (SLightDocument)document);
        }
        catch (SObjectAlreadyExistsException e) {
            throw new SObjectAlreadyExistsException(e);
        }
        catch (SBonitaException e) {
            throw new SObjectCreationException(e);
        }
    }

    @Override
    public void updateDocumentOfList(SMappedDocument mappedDocument, SDocument document, int index) throws SObjectModificationException {
        this.updateDocument(mappedDocument, document, index);
    }

    @Override
    public void updateDocumentIndex(SMappedDocument mappedDocument, int index) throws SObjectModificationException {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("index", index);
        this.updateFields(mappedDocument, params);
    }

    private void updateFields(SDocumentMapping mappedDocument, Map<String, Object> params) throws SObjectModificationException {
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)mappedDocument, params);
        SUpdateEvent updateEvent = null;
        if (this.eventService.hasHandlers("DOCUMENTMAPPING", EventActionType.UPDATED)) {
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("DOCUMENTMAPPING").setObject(mappedDocument).done();
        }
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
        }
        catch (SRecorderException e) {
            throw new SObjectModificationException(e);
        }
    }

    private void updateMapping(long documentId, SDocumentMapping sDocumentMapping, String description, int index) throws SObjectModificationException {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("documentId", documentId);
        params.put("description", description);
        params.put("version", this.incrementVersion(sDocumentMapping.getVersion()));
        params.put("index", index);
        this.updateFields(sDocumentMapping, params);
    }

    private String incrementVersion(String version) {
        Integer intVersion = Integer.valueOf(version);
        return String.valueOf(intVersion + 1);
    }

    private SDocument insertDocument(SDocument document) throws SRecorderException {
        InsertRecord insertRecord = new InsertRecord(document);
        SInsertEvent insertEvent = null;
        if (this.eventService.hasHandlers("DOCUMENT", EventActionType.CREATED)) {
            insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("DOCUMENT").setObject(document).done();
        }
        this.recorder.recordInsert(insertRecord, insertEvent);
        return document;
    }

    @Override
    public void deleteDocumentsFromProcessInstance(Long processInstanceId) throws SBonitaReadException, SObjectModificationException {
        List<SMappedDocument> mappedDocuments;
        do {
            mappedDocuments = this.persistenceService.selectList(SelectDescriptorBuilder.getDocumentMappingsForProcessInstance(processInstanceId, 0, 100, null, null));
            for (SMappedDocument mappedDocument : mappedDocuments) {
                this.removeDocument(mappedDocument);
            }
        } while (!mappedDocuments.isEmpty());
    }

    @Override
    public String generateDocumentURL(String name, String contentStorageId) {
        return this.urlProvider.generateURL(name, contentStorageId);
    }

    @Override
    public SAMappedDocument getArchivedDocument(long archivedProcessDocumentId) throws SObjectNotFoundException {
        try {
            SAMappedDocument docMapping = this.definitiveArchiveReadPersistenceService.selectById(SelectDescriptorBuilder.getArchivedDocumentById(archivedProcessDocumentId));
            if (docMapping == null) {
                throw new SObjectNotFoundException("Document not found with identifier: " + archivedProcessDocumentId);
            }
            return docMapping;
        }
        catch (SBonitaReadException e) {
            throw new SObjectNotFoundException(e);
        }
    }

    @Override
    public SAMappedDocument getArchivedVersionOfProcessDocument(long documentId) throws SObjectNotFoundException {
        try {
            SAMappedDocument aDocMapping = this.definitiveArchiveReadPersistenceService.selectOne(SelectDescriptorBuilder.getArchivedVersionOdDocument(documentId));
            if (aDocMapping == null) {
                throw new SObjectNotFoundException(documentId);
            }
            return aDocMapping;
        }
        catch (SBonitaReadException e) {
            throw new SObjectNotFoundException("Document not found with identifier: " + documentId, e);
        }
    }

    @Override
    public SLightDocument getDocument(long documentId) throws SObjectNotFoundException, SBonitaReadException {
        SLightDocument document = this.persistenceService.selectById(new SelectByIdDescriptor<SLightDocument>("getLightDocumentById", SLightDocument.class, documentId));
        if (document == null) {
            throw new SObjectNotFoundException("Document with id " + documentId + " not found");
        }
        return document;
    }

    @Override
    public SMappedDocument getMappedDocument(long processInstanceId, String documentName) throws SObjectNotFoundException, SBonitaReadException {
        SMappedDocument document = this.getMappedDocumentInternal(processInstanceId, documentName);
        if (document == null) {
            throw new SObjectNotFoundException("Document not found: " + documentName + " for process instance: " + processInstanceId);
        }
        return document;
    }

    private SMappedDocument getMappedDocumentInternal(long processInstanceId, String documentName) throws SBonitaReadException {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("name", documentName);
        SelectOneDescriptor selectOneDescriptor = new SelectOneDescriptor("getSMappedDocumentOfProcessWithName", parameters, SDocument.class);
        return (SMappedDocument)this.persistenceService.selectOne(selectOneDescriptor);
    }

    @Override
    public SMappedDocument getMappedDocument(long processInstanceId, String documentName, long time) throws SObjectNotFoundException, SBonitaReadException {
        List<SAMappedDocument> docMapping = this.definitiveArchiveReadPersistenceService.selectList(SelectDescriptorBuilder.getSAMappedDocumentOfProcessWithName(processInstanceId, documentName, time));
        if (docMapping.isEmpty()) {
            return this.getMappedDocument(processInstanceId, documentName);
        }
        return docMapping.get(0);
    }

    @Override
    public byte[] getDocumentContent(String documentId) throws SObjectNotFoundException {
        try {
            Long id = Long.valueOf(documentId);
            return this.getDocumentWithContent(id).getContent();
        }
        catch (NumberFormatException e) {
            throw new SObjectNotFoundException("Identifier " + documentId + " is not valid, it must be a long");
        }
        catch (SBonitaReadException e) {
            throw new SObjectNotFoundException(e);
        }
    }

    private SDocument getDocumentWithContent(Long id) throws SBonitaReadException, SObjectNotFoundException {
        SDocument document = this.persistenceService.selectById(new SelectByIdDescriptor<SDocument>("geDocumentById", SDocument.class, id));
        if (document == null) {
            throw new SObjectNotFoundException("Document with id " + id + " not found");
        }
        return document;
    }

    @Override
    public SMappedDocument getMappedDocument(long mappingId) throws SObjectNotFoundException, SBonitaReadException {
        SMappedDocument document = this.persistenceService.selectById(new SelectByIdDescriptor<SMappedDocument>("getSMappedDocumentById", SMappedDocument.class, mappingId));
        if (document == null) {
            throw new SObjectNotFoundException("SMappedDocument with id " + mappingId + " not found");
        }
        return document;
    }

    @Override
    public List<SMappedDocument> getDocumentsOfProcessInstance(long processInstanceId, int fromIndex, int numberPerPage, String field, OrderByType order) throws SBonitaReadException {
        return this.persistenceService.selectList(SelectDescriptorBuilder.getDocumentMappingsForProcessInstance(processInstanceId, fromIndex, numberPerPage, field, order));
    }

    @Override
    public long getNumberOfArchivedDocuments(QueryOptions queryOptions) throws SBonitaReadException {
        return this.definitiveArchiveReadPersistenceService.getNumberOfEntities(SAMappedDocument.class, queryOptions, null);
    }

    @Override
    public long getNumberOfArchivedDocumentsSupervisedBy(long userId, QueryOptions queryOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("userId", userId);
        return this.definitiveArchiveReadPersistenceService.getNumberOfEntities(SAMappedDocument.class, "SupervisedBy", queryOptions, parameters);
    }

    @Override
    public long getNumberOfDocuments(QueryOptions queryOptions) throws SBonitaReadException {
        return this.persistenceService.getNumberOfEntities(SMappedDocument.class, queryOptions, null);
    }

    @Override
    public long getNumberOfDocumentsOfProcessInstance(long processInstanceId) throws SBonitaReadException {
        return this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfSMappedDocumentOfProcess(processInstanceId));
    }

    @Override
    public long getNumberOfDocumentsSupervisedBy(long userId, QueryOptions queryOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("userId", userId);
        return this.persistenceService.getNumberOfEntities(SMappedDocument.class, "SupervisedBy", queryOptions, parameters);
    }

    @Override
    public void removeCurrentVersion(SMappedDocument document) throws SObjectModificationException {
        this.archive(document, System.currentTimeMillis());
        this.removeDocument(document);
    }

    @Override
    public void removeCurrentVersion(long processInstanceId, String documentName) throws SObjectNotFoundException, SObjectModificationException {
        try {
            this.removeCurrentVersion(this.getMappedDocument(processInstanceId, documentName));
        }
        catch (SBonitaReadException e) {
            throw new SObjectModificationException(e);
        }
    }

    private void removeArchivedDocument(SAMappedDocument mappedDocument) throws SRecorderException, SBonitaReadException, SObjectNotFoundException {
        this.delete(mappedDocument);
        this.delete(this.getDocument(mappedDocument.getDocumentId()));
    }

    @Override
    public void deleteDocument(SLightDocument document) throws SObjectModificationException {
        try {
            this.delete(document);
        }
        catch (SRecorderException e) {
            throw new SObjectModificationException(e);
        }
    }

    private void delete(SLightDocument document) throws SRecorderException {
        DeleteRecord deleteDocRecord = new DeleteRecord(document);
        SDeleteEvent deleteDocEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("SDocument").setObject(document).done();
        this.recorder.recordDelete(deleteDocRecord, deleteDocEvent);
    }

    private void delete(SADocumentMapping mappedDocument) throws SRecorderException {
        DeleteRecord deleteRecord = new DeleteRecord(mappedDocument);
        SDeleteEvent deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("SADocumentMapping").setObject(mappedDocument).done();
        this.recorder.recordDelete(deleteRecord, deleteEvent);
    }

    @Override
    public void removeDocument(SMappedDocument mappedDocument) throws SObjectModificationException {
        try {
            DeleteRecord deleteRecord = new DeleteRecord(mappedDocument);
            SDeleteEvent deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("SDocumentMapping").setObject(mappedDocument).done();
            this.recorder.recordDelete(deleteRecord, deleteEvent);
        }
        catch (SBonitaException e) {
            throw new SObjectModificationException(e.getMessage(), e);
        }
    }

    @Override
    public List<SAMappedDocument> searchArchivedDocuments(QueryOptions queryOptions) throws SBonitaReadException {
        ReadPersistenceService persistenceService1 = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        return persistenceService1.searchEntity(SAMappedDocument.class, queryOptions, null);
    }

    @Override
    public List<SAMappedDocument> searchArchivedDocumentsSupervisedBy(long userId, QueryOptions queryOptions) throws SBonitaReadException {
        ReadPersistenceService persistenceService1 = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        Map<String, Object> parameters = Collections.singletonMap("userId", userId);
        return persistenceService1.searchEntity(SAMappedDocument.class, "SupervisedBy", queryOptions, parameters);
    }

    @Override
    public List<SMappedDocument> searchDocuments(QueryOptions queryOptions) throws SBonitaReadException {
        try {
            return this.persistenceService.searchEntity(SMappedDocument.class, queryOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaReadException(e);
        }
    }

    @Override
    public List<SMappedDocument> searchDocumentsSupervisedBy(long userId, QueryOptions queryOptions) throws SBonitaReadException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("userId", userId);
            return this.persistenceService.searchEntity(SMappedDocument.class, "SupervisedBy", queryOptions, parameters);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaReadException(e);
        }
    }

    @Override
    public void deleteArchivedDocuments(long instanceId) throws SObjectModificationException {
        FilterOption filterOption = new FilterOption(SAMappedDocument.class, "processInstanceId", instanceId);
        ArrayList<FilterOption> filters = new ArrayList<FilterOption>();
        filters.add(filterOption);
        QueryOptions queryOptions = new QueryOptions(0, 100, null, filters, null);
        try {
            List<SAMappedDocument> documentMappings;
            do {
                documentMappings = this.definitiveArchiveReadPersistenceService.searchEntity(SAMappedDocument.class, queryOptions, null);
                for (SAMappedDocument documentMapping : documentMappings) {
                    this.removeArchivedDocument(documentMapping);
                }
            } while (!documentMappings.isEmpty());
        }
        catch (SBonitaException e) {
            throw new SObjectModificationException(e);
        }
    }

    private SDocumentMapping create(long documentId, long processInstanceId, String name, String description, int index) throws SRecorderException {
        SDocumentMappingImpl documentMapping = new SDocumentMappingImpl(documentId, processInstanceId, name);
        documentMapping.setDescription(description);
        documentMapping.setVersion("1");
        documentMapping.setIndex(index);
        InsertRecord insertRecord = new InsertRecord(documentMapping);
        SInsertEvent insertEvent = null;
        if (this.eventService.hasHandlers("DOCUMENTMAPPING", EventActionType.CREATED)) {
            insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("DOCUMENTMAPPING").setObject(documentMapping).done();
        }
        this.recorder.recordInsert(insertRecord, insertEvent);
        return documentMapping;
    }

    @Override
    public void archive(SDocumentMapping docMapping, long archiveDate) throws SObjectModificationException {
        if (this.archiveService.isArchivable(SDocumentMapping.class)) {
            SADocumentMappingImpl saDocumentMapping = new SADocumentMappingImpl(docMapping.getDocumentId(), docMapping.getProcessInstanceId(), archiveDate, docMapping.getId(), docMapping.getName(), docMapping.getDescription(), docMapping.getVersion());
            saDocumentMapping.setIndex(docMapping.getIndex());
            ArchiveInsertRecord insertRecord = new ArchiveInsertRecord(saDocumentMapping);
            try {
                this.archiveService.recordInsert(archiveDate, insertRecord);
            }
            catch (SBonitaException e) {
                throw new SObjectModificationException("Unable to archive the document with id = <" + docMapping.getId() + ">", e);
            }
        }
    }

    @Override
    public List<SMappedDocument> getDocumentList(String documentName, long processInstanceId, int fromIndex, int numberOfResult) throws SBonitaReadException {
        return this.persistenceService.selectList(SelectDescriptorBuilder.getDocumentList(documentName, processInstanceId, new QueryOptions(fromIndex, numberOfResult)));
    }

    @Override
    public void deleteContentOfArchivedDocument(long archivedDocumentId) throws SObjectNotFoundException, SBonitaReadException, SRecorderException {
        SAMappedDocument archivedDocument = this.getArchivedDocument(archivedDocumentId);
        SDocument document = this.getDocumentWithContent(archivedDocument.getDocumentId());
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)document, Collections.singletonMap("content", null));
        SUpdateEvent updateEvent = null;
        if (this.eventService.hasHandlers("DOCUMENT", EventActionType.UPDATED)) {
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("DOCUMENT").setObject(document).done();
        }
        this.recorder.recordUpdate(updateRecord, updateEvent);
    }

    @Override
    public SMappedDocument updateDocument(long documentId, SDocument sDocument) throws SBonitaReadException, SObjectNotFoundException, SObjectModificationException {
        SMappedDocument sDocumentMapping = this.getMappedDocument(documentId);
        return this.updateDocument(sDocumentMapping, sDocument);
    }

    @Override
    public SMappedDocument updateDocument(SDocumentMapping documentToUpdate, SDocument sDocument) throws SObjectModificationException {
        return this.updateDocument(documentToUpdate, sDocument, documentToUpdate.getIndex());
    }

    private SMappedDocument updateDocument(SDocumentMapping documentToUpdate, SDocument sDocument, int index) throws SObjectModificationException {
        try {
            this.insertDocument(sDocument);
        }
        catch (SRecorderException e) {
            throw new SObjectModificationException(e);
        }
        this.archive(documentToUpdate, System.currentTimeMillis());
        this.updateMapping(sDocument.getId(), documentToUpdate, documentToUpdate.getDescription(), index);
        return new SMappedDocumentImpl(documentToUpdate, (SLightDocument)sDocument);
    }

    @Override
    public List<SMappedDocument> getDocumentList(String documentName, long processInstanceId, long time) throws SBonitaReadException {
        List<SAMappedDocument> archivedList = this.persistenceService.selectList(SelectDescriptorBuilder.getArchivedDocumentList(documentName, processInstanceId, new QueryOptions(0, Integer.MAX_VALUE), time));
        List<SMappedDocument> elementsInJournal = this.persistenceService.selectList(SelectDescriptorBuilder.getDocumentListCreatedBefore(documentName, processInstanceId, new QueryOptions(0, Integer.MAX_VALUE), time));
        ArrayList<SMappedDocument> result = new ArrayList<SMappedDocument>(archivedList.size() + elementsInJournal.size());
        for (SAMappedDocument sAMappedDocument : archivedList) {
            result.add(sAMappedDocument);
        }
        for (SMappedDocument sMappedDocument : elementsInJournal) {
            result.add(sMappedDocument);
        }
        return result;
    }
}

