/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.document.model.builder.impl;

import org.bonitasoft.engine.core.document.model.builder.SDocumentBuilder;
import org.bonitasoft.engine.core.document.model.builder.SDocumentBuilderFactory;
import org.bonitasoft.engine.core.document.model.builder.impl.SDocumentBuilderImpl;

public class SDocumentBuilderFactoryImpl
implements SDocumentBuilderFactory {
    static final String ID = "id";
    static final String NAME = "name";
    static final String AUTHOR = "author";
    static final String CREATION_DATE = "creationDate";
    static final String HAS_CONTENT = "hasContent";
    static final String FILENAME = "fileName";
    static final String MIMETYPE = "mimeType";
    static final String URL = "url";
    static final String VERSION = "version";
    static final String DESCRIPTION = "description";
    static final String INDEX = "index";

    @Override
    public SDocumentBuilder createNewInstance(String fileName, String mimetype, long authorId) {
        SDocumentBuilderImpl sDocumentBuilderImpl = new SDocumentBuilderImpl();
        sDocumentBuilderImpl.setFileName(fileName);
        sDocumentBuilderImpl.setMimeType(mimetype);
        sDocumentBuilderImpl.setAuthor(authorId);
        sDocumentBuilderImpl.setCreationDate(System.currentTimeMillis());
        return sDocumentBuilderImpl;
    }

    @Override
    public SDocumentBuilder createNewProcessDocument(String fileName, String mimetype, long authorId, byte[] content) {
        SDocumentBuilder sDocumentBuilder = this.createNewInstance(fileName, mimetype, authorId);
        sDocumentBuilder.setContent(content);
        sDocumentBuilder.setHasContent(true);
        return sDocumentBuilder;
    }

    @Override
    public SDocumentBuilder createNewExternalProcessDocumentReference(String fileName, String mimetype, long authorId, String url) {
        SDocumentBuilder sDocumentBuilder = this.createNewInstance(fileName, mimetype, authorId);
        sDocumentBuilder.setURL(url);
        sDocumentBuilder.setHasContent(false);
        return sDocumentBuilder;
    }

    @Override
    public String getIdKey() {
        return ID;
    }

    @Override
    public String getNameKey() {
        return NAME;
    }

    @Override
    public String getAuthorKey() {
        return AUTHOR;
    }

    @Override
    public String getCreationDateKey() {
        return CREATION_DATE;
    }

    @Override
    public String getHasContentKey() {
        return HAS_CONTENT;
    }

    @Override
    public String getFileNameKey() {
        return FILENAME;
    }

    @Override
    public String getMimeTypeKey() {
        return MIMETYPE;
    }

    @Override
    public String getURLKey() {
        return URL;
    }

    @Override
    public String getDescriptionKey() {
        return DESCRIPTION;
    }

    @Override
    public String getVersionKey() {
        return VERSION;
    }

    @Override
    public String getIndexKey() {
        return INDEX;
    }
}

