/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SCallActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.SSubProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SBoundaryEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SEndEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SStartEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SCatchErrorEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SErrorEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SEventTriggerDefinition;
import org.bonitasoft.engine.core.process.instance.api.FlowNodeInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventReadException;
import org.bonitasoft.engine.core.process.instance.model.SCallActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.builder.SCallActivityInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SFlowNodeInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SProcessInstanceUpdateBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SProcessInstanceUpdateBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.event.SBoundaryEventInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.event.SEventInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.event.SIntermediateCatchEventInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.event.SIntermediateThrowEventInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.event.handling.SWaitingErrorEventBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.event.handling.SWaitingErrorEventBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.event.SBoundaryEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SCatchEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SThrowEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SBPMEventType;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingErrorEvent;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingEvent;
import org.bonitasoft.engine.execution.ContainerRegistry;
import org.bonitasoft.engine.execution.TransactionContainedProcessInstanceInterruptor;
import org.bonitasoft.engine.execution.event.CoupleEventHandlerStrategy;
import org.bonitasoft.engine.execution.event.EventsHandler;
import org.bonitasoft.engine.execution.event.OperationsWithContext;
import org.bonitasoft.engine.execution.event.SBPMEventHandlerException;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;

public class ErrorEventHandlerStrategy
extends CoupleEventHandlerStrategy {
    private static final OperationsWithContext EMPTY = new OperationsWithContext(null, null);
    private final ProcessInstanceService processInstanceService;
    private final FlowNodeInstanceService flowNodeInstanceService;
    private final ContainerRegistry containerRegistry;
    private final ProcessDefinitionService processDefinitionService;
    private final EventsHandler eventsHandler;
    private final TechnicalLoggerService logger;

    public ErrorEventHandlerStrategy(EventInstanceService eventInstanceService, ProcessInstanceService processInstanceService, FlowNodeInstanceService flowNodeInstanceService, ContainerRegistry containerRegistry, ProcessDefinitionService processDefinitionService, EventsHandler eventsHandler, TechnicalLoggerService logger) {
        super(eventInstanceService);
        this.processInstanceService = processInstanceService;
        this.flowNodeInstanceService = flowNodeInstanceService;
        this.containerRegistry = containerRegistry;
        this.processDefinitionService = processDefinitionService;
        this.eventsHandler = eventsHandler;
        this.logger = logger;
    }

    @Override
    public void handleThrowEvent(SProcessDefinition processDefinition, SEventDefinition eventDefinition, SThrowEventInstance eventInstance, SEventTriggerDefinition sEventTriggerDefinition) throws SBonitaException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Error event is thrown, error code = " + ((SErrorEventTriggerDefinition)sEventTriggerDefinition).getErrorCode() + " process instance = " + eventInstance.getRootContainerId());
        }
        TransactionContainedProcessInstanceInterruptor processInstanceInterruptor = new TransactionContainedProcessInstanceInterruptor(this.processInstanceService, this.getEventInstanceService(), this.containerRegistry, this.logger);
        this.updateInterruptorErrorEvent(eventInstance);
        processInstanceInterruptor.interruptChildrenOnly(eventInstance.getParentContainerId(), SStateCategory.ABORTING, -1L, eventInstance.getId());
    }

    private void updateInterruptorErrorEvent(SThrowEventInstance eventInstance) throws SProcessInstanceNotFoundException, SProcessInstanceReadException, SProcessInstanceModificationException {
        SIntermediateThrowEventInstanceBuilderFactory throwEventKeyProvider = BuilderFactory.get(SIntermediateThrowEventInstanceBuilderFactory.class);
        SProcessInstanceUpdateBuilder updateBuilder = BuilderFactory.get(SProcessInstanceUpdateBuilderFactory.class).createNewInstance();
        long parentProcessInstanceId = eventInstance.getLogicalGroup(throwEventKeyProvider.getParentProcessInstanceIndex());
        updateBuilder.updateInterruptingEventId(eventInstance.getId());
        SProcessInstance processInstance = this.processInstanceService.getProcessInstance(parentProcessInstanceId);
        this.processInstanceService.updateProcess(processInstance, updateBuilder.done());
    }

    @Override
    public void handleThrowEvent(SEventTriggerDefinition sEventTriggerDefinition) {
    }

    @Override
    public boolean handlePostThrowEvent(SProcessDefinition processDefinition, SEndEventDefinition sEventDefinition, SThrowEventInstance sThrowEventInstance, SEventTriggerDefinition sEventTriggerDefinition, SFlowNodeInstance sFlowNodeInstance) throws SBonitaException {
        boolean hasActionToExecute = false;
        SFlowNodeInstanceBuilderFactory flowNodeKeyProvider = BuilderFactory.get(SIntermediateThrowEventInstanceBuilderFactory.class);
        long parentProcessInstanceId = sThrowEventInstance.getLogicalGroup(flowNodeKeyProvider.getParentProcessInstanceIndex());
        SErrorEventTriggerDefinition errorTrigger = (SErrorEventTriggerDefinition)sEventTriggerDefinition;
        SWaitingErrorEvent waitingErrorEvent = this.getWaitingErrorEvent(processDefinition.getProcessContainer(), parentProcessInstanceId, errorTrigger, sThrowEventInstance, sFlowNodeInstance);
        if (waitingErrorEvent != null) {
            this.eventsHandler.triggerCatchEvent(waitingErrorEvent, sThrowEventInstance.getId());
            hasActionToExecute = true;
        } else if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) {
            StringBuilder logBuilder = new StringBuilder();
            logBuilder.append("No catch error event was defined to handle the error code '");
            logBuilder.append(errorTrigger.getErrorCode());
            logBuilder.append("' defined in the process [name: ");
            logBuilder.append(processDefinition.getName());
            logBuilder.append(", version: ");
            logBuilder.append(processDefinition.getVersion());
            logBuilder.append("]");
            if (sEventDefinition != null) {
                logBuilder.append(", throw event: ");
                logBuilder.append(sEventDefinition.getName());
            }
            logBuilder.append(". This throw error event will act as a Terminate Event.");
            this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, logBuilder.toString());
        }
        return hasActionToExecute;
    }

    private SWaitingErrorEvent getWaitingErrorEvent(SFlowElementContainerDefinition container, long parentProcessInstanceId, SErrorEventTriggerDefinition errorTrigger, SThrowEventInstance eventInstance, SFlowNodeInstance flowNodeInstance) throws SBonitaException {
        SProcessInstance processInstance = this.processInstanceService.getProcessInstance(parentProcessInstanceId);
        String errorCode = errorTrigger.getErrorCode();
        SWaitingErrorEvent waitingErrorEvent = this.getWaitingErrorEventFromBoundary(eventInstance, errorCode, flowNodeInstance);
        if (waitingErrorEvent == null) {
            waitingErrorEvent = this.getWaitingErrorEventSubProcess(container, parentProcessInstanceId, errorCode);
        }
        if (waitingErrorEvent == null && processInstance.getCallerId() != -1L && SFlowNodeType.CALL_ACTIVITY.equals((Object)processInstance.getCallerType())) {
            waitingErrorEvent = this.getWaitingErrorEventFromCallActivity(errorTrigger, processInstance, eventInstance, errorCode, flowNodeInstance);
        }
        return waitingErrorEvent;
    }

    protected SWaitingErrorEvent getWaitingErrorEventFromBoundary(SThrowEventInstance eventInstance, String errorCode, SFlowNodeInstance flowNodeInstance) throws SBonitaException {
        SWaitingErrorEvent waitingErrorEvent;
        SFlowNodeInstanceBuilderFactory flowNodeKeyProvider = BuilderFactory.get(SBoundaryEventInstanceBuilderFactory.class);
        long logicalGroup = eventInstance.getLogicalGroup(flowNodeKeyProvider.getParentActivityInstanceIndex());
        if (logicalGroup <= 0L) {
            return null;
        }
        long processDefinitionId = flowNodeInstance.getLogicalGroup(flowNodeKeyProvider.getProcessDefinitionIndex());
        SProcessDefinition processDefinition = this.processDefinitionService.getProcessDefinition(processDefinitionId);
        SActivityDefinition flowNode = (SActivityDefinition)processDefinition.getProcessContainer().getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
        List<SBoundaryEventDefinition> boundaryEventDefinitions = flowNode.getBoundaryEventDefinitions();
        if (flowNode.getLoopCharacteristics() == null) {
            waitingErrorEvent = this.getWaitingErrorEventFromBoundary(errorCode, flowNodeInstance, boundaryEventDefinitions);
        } else {
            long multipleInstanceActivityId = flowNodeInstance.getLogicalGroup(flowNodeKeyProvider.getParentActivityInstanceIndex());
            SFlowNodeInstance miActivityInstance = this.flowNodeInstanceService.getFlowNodeInstance(multipleInstanceActivityId);
            waitingErrorEvent = this.getWaitingErrorEventFromBoundary(errorCode, miActivityInstance, boundaryEventDefinitions);
        }
        return waitingErrorEvent;
    }

    private SWaitingErrorEvent getWaitingErrorEventFromCallActivity(SErrorEventTriggerDefinition errorTrigger, SProcessInstance processInstance, SThrowEventInstance eventInstance, String errorCode, SFlowNodeInstance flowNodeInstance) throws SBonitaException {
        SWaitingErrorEvent waitingErrorEvent;
        SFlowNodeInstanceBuilderFactory flowNodeKeyProvider = BuilderFactory.get(SCallActivityInstanceBuilderFactory.class);
        SCallActivityInstance callActivityInstance = (SCallActivityInstance)this.getEventInstanceService().getFlowNodeInstance(processInstance.getCallerId());
        long processDefinitionId = callActivityInstance.getLogicalGroup(flowNodeKeyProvider.getProcessDefinitionIndex());
        SProcessDefinition callActivityContainer = this.processDefinitionService.getProcessDefinition(processDefinitionId);
        SCallActivityDefinition callActivityDef = (SCallActivityDefinition)callActivityContainer.getProcessContainer().getFlowNode(callActivityInstance.getFlowNodeDefinitionId());
        List<SBoundaryEventDefinition> boundaryEventDefinitions = callActivityDef.getBoundaryEventDefinitions();
        if (callActivityDef.getLoopCharacteristics() != null) {
            long multipleInstanceActivityId = callActivityInstance.getLogicalGroup(flowNodeKeyProvider.getParentActivityInstanceIndex());
            SFlowNodeInstance miActivityInstance = this.flowNodeInstanceService.getFlowNodeInstance(multipleInstanceActivityId);
            waitingErrorEvent = this.getWaitingErrorEventFromBoundary(errorCode, miActivityInstance, boundaryEventDefinitions);
        } else {
            waitingErrorEvent = this.getWaitingErrorEventFromBoundary(errorCode, callActivityInstance, boundaryEventDefinitions);
        }
        if (waitingErrorEvent == null) {
            long callActivityParentProcInstId = callActivityInstance.getLogicalGroup(flowNodeKeyProvider.getParentProcessInstanceIndex());
            waitingErrorEvent = this.getWaitingErrorEvent(callActivityContainer.getProcessContainer(), callActivityParentProcInstId, errorTrigger, eventInstance, flowNodeInstance);
        }
        return waitingErrorEvent;
    }

    protected SWaitingErrorEvent getWaitingErrorEventFromBoundary(String errorCode, SFlowNodeInstance flowNodeInstance, List<SBoundaryEventDefinition> boundaryEventDefinitions) throws SWaitingEventReadException {
        String catchingErrorCode = errorCode;
        boolean canHandleError = this.containsHandler(boundaryEventDefinitions, catchingErrorCode);
        if (!canHandleError) {
            catchingErrorCode = null;
            canHandleError = this.containsHandler(boundaryEventDefinitions, catchingErrorCode);
        }
        if (canHandleError) {
            return this.getEventInstanceService().getBoundaryWaitingErrorEvent(flowNodeInstance.getId(), catchingErrorCode);
        }
        return null;
    }

    private SWaitingErrorEvent getWaitingErrorEventSubProcess(SFlowElementContainerDefinition container, long parentProcessInstanceId, String errorCode) throws SBonitaReadException, SBPMEventHandlerException {
        String catchingErrorCode = errorCode;
        boolean canHandleError = this.hasEventSubProcessCatchingError(container, catchingErrorCode);
        if (!canHandleError) {
            catchingErrorCode = null;
            canHandleError = this.hasEventSubProcessCatchingError(container, catchingErrorCode);
        }
        SWaitingErrorEvent waitingErrorEvent = null;
        if (canHandleError) {
            SWaitingErrorEventBuilderFactory waitingErrorEventKeyProvider = BuilderFactory.get(SWaitingErrorEventBuilderFactory.class);
            OrderByOption orderByOption = new OrderByOption(SWaitingEvent.class, waitingErrorEventKeyProvider.getFlowNodeNameKey(), OrderByType.ASC);
            ArrayList<FilterOption> filters = new ArrayList<FilterOption>(3);
            filters.add(new FilterOption(SWaitingErrorEvent.class, waitingErrorEventKeyProvider.getErrorCodeKey(), catchingErrorCode));
            filters.add(new FilterOption(SWaitingErrorEvent.class, waitingErrorEventKeyProvider.getEventTypeKey(), SBPMEventType.EVENT_SUB_PROCESS.name()));
            filters.add(new FilterOption(SWaitingErrorEvent.class, waitingErrorEventKeyProvider.getParentProcessInstanceIdKey(), parentProcessInstanceId));
            QueryOptions queryOptions = new QueryOptions(0, 2, Collections.singletonList(orderByOption), filters, null);
            List<SWaitingErrorEvent> waitingEvents = this.getEventInstanceService().searchWaitingEvents(SWaitingErrorEvent.class, queryOptions);
            if (waitingEvents.size() != 1) {
                StringBuilder stb = new StringBuilder();
                stb.append("One and only one error start event sub-process was expected for the process instance ");
                stb.append(parentProcessInstanceId);
                stb.append(" and error code ");
                stb.append(catchingErrorCode);
                stb.append(", but ");
                stb.append(waitingEvents.size());
                stb.append(" was found.");
                throw new SBPMEventHandlerException(stb.toString());
            }
            waitingErrorEvent = waitingEvents.get(0);
        }
        return waitingErrorEvent;
    }

    private boolean containsHandler(List<SBoundaryEventDefinition> boundaryEventDefinitions, String errorCode) {
        boolean found = false;
        Iterator<SBoundaryEventDefinition> iterator = boundaryEventDefinitions.iterator();
        while (iterator.hasNext() && !found) {
            SBoundaryEventDefinition boundaryEventDefinition = iterator.next();
            SCatchErrorEventTriggerDefinition currentErrorTrigger = boundaryEventDefinition.getErrorEventTriggerDefinition(errorCode);
            if (currentErrorTrigger == null) continue;
            found = true;
        }
        return found;
    }

    private boolean hasEventSubProcessCatchingError(SFlowElementContainerDefinition container, String errorCode) {
        boolean found = false;
        Iterator<SActivityDefinition> iterator = container.getActivities().iterator();
        while (iterator.hasNext() && !found) {
            SSubProcessDefinition eventSubProcess;
            SStartEventDefinition startEventDefinition;
            SActivityDefinition activity = iterator.next();
            if (!SFlowNodeType.SUB_PROCESS.equals((Object)activity.getType()) || !((SSubProcessDefinition)activity).isTriggeredByEvent() || (startEventDefinition = (eventSubProcess = (SSubProcessDefinition)activity).getSubProcessContainer().getStartEvents().get(0)).getErrorEventTriggerDefinition(errorCode) == null) continue;
            found = true;
        }
        return found;
    }

    @Override
    public void handleCatchEvent(SProcessDefinition processDefinition, SEventDefinition eventDefinition, SCatchEventInstance eventInstance, SEventTriggerDefinition sEventTriggerDefinition) throws SBonitaException {
        SWaitingErrorEventBuilderFactory builderFact = BuilderFactory.get(SWaitingErrorEventBuilderFactory.class);
        SErrorEventTriggerDefinition errorEventTriggerDefinition = (SErrorEventTriggerDefinition)sEventTriggerDefinition;
        SEventInstanceBuilderFactory eventInstanceKeyProvider = BuilderFactory.get(SIntermediateCatchEventInstanceBuilderFactory.class);
        switch (eventDefinition.getType()) {
            case BOUNDARY_EVENT: {
                SBoundaryEventInstance boundary = (SBoundaryEventInstance)eventInstance;
                long rootProcessInstanceId = eventInstance.getLogicalGroup(eventInstanceKeyProvider.getRootProcessInstanceIndex());
                long parentProcessInstanceId = eventInstance.getLogicalGroup(eventInstanceKeyProvider.getParentProcessInstanceIndex());
                SWaitingErrorEventBuilder builder = builderFact.createNewWaitingErrorBoundaryEventInstance(processDefinition.getId(), rootProcessInstanceId, parentProcessInstanceId, eventInstance.getId(), errorEventTriggerDefinition.getErrorCode(), processDefinition.getName(), eventInstance.getFlowNodeDefinitionId(), eventInstance.getName(), boundary.getActivityInstanceId());
                SWaitingErrorEvent errorEvent = builder.done();
                this.getEventInstanceService().createWaitingEvent(errorEvent);
                break;
            }
            case INTERMEDIATE_CATCH_EVENT: 
            case START_EVENT: {
                throw new SWaitingEventCreationException("Catch error event cannot be put in " + (Object)((Object)eventDefinition.getType()) + ". They must be used as boundary events or start event subprocess.");
            }
            default: {
                throw new SWaitingEventCreationException((Object)((Object)eventDefinition.getType()) + " is not a catch event.");
            }
        }
    }

    @Override
    public OperationsWithContext getOperations(SWaitingEvent waitingEvent, Long triggeringElementID) {
        return EMPTY;
    }

    @Override
    public void handleEventSubProcess(SProcessDefinition processDefinition, SEventDefinition eventDefinition, SEventTriggerDefinition sEventTriggerDefinition, long subProcessId, SProcessInstance parentProcessInstance) throws SBonitaException {
        SWaitingErrorEventBuilderFactory builderFact = BuilderFactory.get(SWaitingErrorEventBuilderFactory.class);
        SErrorEventTriggerDefinition trigger = (SErrorEventTriggerDefinition)sEventTriggerDefinition;
        SWaitingErrorEventBuilder builder = builderFact.createNewWaitingErrorEventSubProcInstance(processDefinition.getId(), parentProcessInstance.getId(), parentProcessInstance.getRootProcessInstanceId(), trigger.getErrorCode(), processDefinition.getName(), eventDefinition.getId(), eventDefinition.getName(), subProcessId);
        SWaitingErrorEvent event = builder.done();
        this.getEventInstanceService().createWaitingEvent(event);
    }
}

